package io.baltoro.service;

import java.util.List;

import io.baltoro.domain.AppUserSession;
import io.baltoro.domain.BaltoroAppAPI;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.domain.BaltoroInstanceRequest;
import io.baltoro.exception.ServiceException;
import io.baltoro.to.ReplicationContext;
import io.baltoro.to.ReplicationTO;

public interface InstanceDAO
{
	BaltoroInstance getInstance(String uuid) throws ServiceException;
	
	List<BaltoroInstance> find(String appUuid) throws ServiceException;
	
	BaltoroInstance insertInstance(BaltoroInstance obj) throws ServiceException;
	
	void updateInstance(String uuid, String state, int cpuPercent, int memGB) throws ServiceException;
	
	void updateInstanceStartedOn(String uuid, String clusterPath, String remoteAddress, int threads) throws ServiceException;
	
	void closeDeadInstances() throws ServiceException;
	
	public String findInstances(String appUuid, String serviceName) throws ServiceException;
	
	public List<String> findDeadInstances() throws ServiceException;
	
	void deleteInstances(String uuid) throws ServiceException;
	
	List<BaltoroAppAPI> getAppAPI(String appUuid) throws ServiceException;
	
	BaltoroAppAPI insert(BaltoroAppAPI obj) throws ServiceException;
	
	void update(String uuid, BaltoroAppAPI obj) throws ServiceException;
	
	BaltoroInstanceRequest insert(BaltoroInstanceRequest obj) throws ServiceException;
	
	void updateRequest(String uuid, int millis, int sizeKB, String error) throws ServiceException;
	
	void createUserSession(AppUserSession session) throws ServiceException;
	
	void touchAppUserSession(String uuid) throws ServiceException;
	
	void updateAppUserSessionAtt(String uuid, String userName, String json) throws ServiceException;
	
	void closeAppUserSession(String uuid) throws ServiceException;
	
	AppUserSession getUserSessionByUuid(String uuid) throws ServiceException;
	
	List<AppUserSession> getUserSessionByAppUuid(String appUuid) throws ServiceException;
	
	void insert(String appUuuid, String instUuid, ReplicationContext ctx) throws ServiceException;
	
	List<ReplicationContext> getReplication(ReplicationTO to) throws ServiceException;
}
