package io.baltoro.remote;

import java.nio.ByteBuffer;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.to.WSTO;

public class RequestWorker extends  Thread
{
	private WSTO to;
	private SessionInstance session;
	static ObjectMapper objectMapper = new ObjectMapper();
	boolean run = true;
	static int _count;
	int count;
	long lastWorked = System.currentTimeMillis();
	
	RequestWorker()
	{
		synchronized (RequestWorker.class.getName().intern())
		{
			count = _count++;
		}
		
	}
	
	void set(WSTO to, SessionInstance session)
	{
	
		this.to = to;
		this.session = session;
		
		synchronized (this)
		{
			this.notify();
		}
	}
	
	void clear()
	{
		this.to = null;
		this.session = null;
	}
	
	public void run()
	{
		while (run)
		{
			if(to == null)
			{
				synchronized (this)
				{
					try
					{
						this.wait(30000);
						
						if(to == null)
						{
							//System.out.println("worker thread no work to do , continue ... "+this+",  --- "+count+" ---> "+WorkerPool.info());
							continue;
						}
					} 
					catch (InterruptedException e)
					{
						e.printStackTrace();
					}
				}
			}
			
			try
			{
				work();
				
				String sync = to.appName+"-"+to.serviceName+"-queue";
				
				//String sync = to.appUuid+"-queue";
				synchronized (sync.intern())
				{
					sync.intern().notify();
				}
				
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
			finally 
			{
				to = null;
				session = null;
				lastWorked = System.currentTimeMillis();
				WorkerPool.done(this);
			}
			
		}
	}
	
	
	public void work() throws Exception
	{
		
		
		session.working = true;
		//long t0 = System.currentTimeMillis();
		
		byte[] data = objectMapper.writeValueAsBytes(to);
		ByteBuffer buffer = ByteBuffer.wrap(data);
		
		//synchronized (key.intern())
		{
			//session.getSession().getBasicRemote().sendBinary(buffer);
		}
		
		session.working = false;
			
	}
}