/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.RequestQueue;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.WorkerPool;
import io.baltoro.to.WSTO;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WSRequestPoller
extends Thread {
    boolean run = true;
    static ObjectMapper mapper = new ObjectMapper();

    @Override
    public void run() {
        while (this.run) {
            ConcurrentLinkedQueue queue = RequestQueue.instance().getQueue();
            if (queue == null || queue.size() == 0) {
                this.sleep("request queue is empty !");
                continue;
            }
            ByteBuffer byteBuffer = (ByteBuffer)queue.peek();
            if (byteBuffer == null) {
                this.sleep(" No items in request queue !");
                continue;
            }
            byteBuffer = (ByteBuffer)queue.poll();
            WSTO to = this.getWSTO(byteBuffer);
            RequestWorker worker = WorkerPool.getRequestWorker();
            if (worker == null) {
                worker = new RequestWorker();
                worker.start();
            }
            worker.set(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(String text) {
        try {
            long t0 = System.currentTimeMillis();
            String sync = "request-queue";
            String string = sync.intern();
            synchronized (string) {
                sync.intern().wait(50000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private WSTO getWSTO(ByteBuffer byteBuffer) {
        byte[] jsonBytes = byteBuffer.array();
        WSTO to = null;
        try {
            to = (WSTO)mapper.readValue(jsonBytes, WSTO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return to;
    }
}

