package io.baltoro.service;

import java.util.ArrayList;
import java.util.List;

import io.baltoro.domain.App;
import io.baltoro.domain.BO;
import io.baltoro.domain.PrivateData;
import io.baltoro.domain.User;
import io.baltoro.exception.ServiceException;
import io.baltoro.to.AppTO;
import io.baltoro.to.BaseTO;
import io.baltoro.to.PrivateDataTO;
import io.baltoro.to.UserTO;
import io.baltoro.util.ObjectUtil;

public class TOFactory
{

	public static <T extends BaseTO> T getTO(BO _bo, Class<T> type)
	throws ServiceException
	{
		
		BaseTO baseTO = null;
		try
		{
			baseTO = type.newInstance();
		} 
		catch (Exception e)
		{
			throw new ServiceException(e);
		}
		
		
		baseTO.uuid = _bo.getBaseUuid();
		baseTO.name = _bo.getName();
		baseTO.containerUuid = _bo.getContainerUuid();
		baseTO.createdBy = _bo.getCreatedBy();
		baseTO.createdOn = _bo.getCreatedOn().getTime();
		
		if(_bo instanceof User)
		{
			User bo = (User) _bo;
			UserTO to = (UserTO) baseTO;
			to.email = bo.getEmail();
			return type.cast(to);
		}
		
		if(_bo instanceof App)
		{
			App bo = (App) _bo;
			AppTO to = (AppTO) baseTO;
			to.publicKey = bo.getPublicKey();
			to.privateDataUuid = bo.getPrivateDataUuid();
			return type.cast(to);
		}
		
		
		if(_bo instanceof PrivateData)
		{
			PrivateData bo = (PrivateData) _bo;
			PrivateDataTO to = (PrivateDataTO) baseTO;
			to.password = bo.getPassword();
			to.privateKey = bo.getPrivateKey();
			return type.cast(to);
		}
		
		return type.cast(baseTO);
	}
	
	public static <T extends BaseTO> List<?> getTO(List<BO> inList)
	throws ServiceException
	{
		List<BaseTO> list = new ArrayList<BaseTO>(inList.size());
		for (BO bo : inList)
		{
			Class<T> _class = (Class<T>) ObjectUtil.fromTypeTO(bo.getObjectType());
			BaseTO to = getTO(bo, _class);
			list.add(to);
		}
		
		return list;
	}
	
}
