package io.baltoro.service;

import io.baltoro.domain.Permission;
import io.baltoro.exception.CreateNotAllowedException;
import io.baltoro.exception.PermissionException;
import io.baltoro.exception.ReadNotAllowedException;
import io.baltoro.exception.ServiceException;
import io.baltoro.exception.UpdateNotAllowedException;

public class PermissionResolver 
{

	//private static Log log = LogFactory.getLog(PermissionResolver.class);
	
	static void checkReadAllowed(String baseUuid)
	throws PermissionException, ServiceException
	{
		Dao dao = DaoFactory.getInstance();
		Permission p = dao.getPermission(baseUuid);	
		
		if(p instanceof NullPermission)
		{
			throw new PermissionException("no permission records", baseUuid, Ctx.getUserUuid());
		}
		
		if(!p.isRead())
		{
			throw new ReadNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
	}
	
	
	static void checkCreateAllowed(String baseUuid)
	throws PermissionException, ServiceException
	{
		Dao dao = DaoFactory.getInstance();
		Permission p = dao.getPermission(baseUuid);	
		
		if(p instanceof NullPermission)
		{
			throw new PermissionException("no permission records", baseUuid, Ctx.getUserUuid());
		}
		
		if(!p.isRead())
		{
			throw new ReadNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
		if(!p.isCreate())
		{
			throw new CreateNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
	}
	
	static void checkUpdateAllowed(String baseUuid)
	throws PermissionException, ServiceException
	{
		Dao dao = DaoFactory.getInstance();
		Permission p = dao.getPermission(baseUuid);	
		
		if(p instanceof NullPermission)
		{
			throw new ReadNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
		if(!p.isRead())
		{
			throw new ReadNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
		if(!p.isCreate())
		{
			throw new UpdateNotAllowedException(baseUuid, Ctx.getUserUuid());
		}
		
	}
}
