package io.baltoro.service;

import io.baltoro.domain.BODefaults;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.domain.User;

public class Ctx
{
	
	private static ThreadLocal<User> ctxUser = new ThreadLocal<User>();
	private static final User baseUser = new User();
	private static ThreadLocal<String> ctxError = new ThreadLocal<String>();
	

	static
	{
		//baseUser = new User();
		baseUser.setBaseUuid(BODefaults.BASE_USER);
		baseUser.setVersionNumber(1);
		baseUser.setName(BODefaults.BASE_USER);
		baseUser.setObjectType(ObjectTypeEnum.USER.toString());
		baseUser.setVersionUuid(BODefaults.BASE_USER);
		baseUser.setLatestVersionUuid(BODefaults.BASE_USER);
		baseUser.setContainerUuid(BODefaults.BASE_CONTAINER);
		baseUser.setCreatedBy(BODefaults.BASE_USER);
		
		
		/*
		String pubKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCjol6wsbVoP7lwo8IeXt2/Rm3bpAvttMsCbxyjyM6K46tuS"
						+"VN1PTt+uZoZJmVBiCiu8bUUJV5OHA6776hieiNbmNOvyZKw+zcphbfNCppoa1Z3I6kGkhil0SGEH+VqIpJ0HFNjq"
						+"bU+dFCh9Lle3dSd+rSF81tXHWDRrQ+HIX9YbwIDAQAB";
		
		
		String privKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKOiXrCxtWg/uXCjwh5e3b9GbdukC+20ywJvHKP"
				+ "Izorjq25JU3U9O365mhkmZUGIKK7xtRQlXk4cDrvvqGJ6I1uY06/JkrD7NymFt80KmmhrVncjqQaSGKXRIYQf5WoiknQcU2"
				+ "OptT50UKH0uV7d1J36tIXzW1cdYNGtD4chf1hvAgMBAAECgYAFMWw+jW/nd/9TRdA+ofeSi+enTPJtCGnQ7uR1qFYxcnod6L"
				+ "P1v+F3FdfEZEvzsFO7RVUCPO716cXF7z5cIKYMKg/+r8QsHU153sA53M9FYlq0eyELU23AqSCgtInPlIks1d3ktlsp4CKb97"
				+ "KeqWGYd0tpmEqYJ9z4bMGG8+UK4QJBANTmH099BTebX9Yoh8FYYysxa3xSzjtFqRU/N9A1/YQJUm4E0T2AX6aGtJt3hrUIHG7"
				+ "C9eNCvkUpW5IksOJ229cCQQDEwwQfu6+epsU126OW4Amc4/Q0togBz+hGjHRohIbmfQPuI6aYI3Ih5xgDWpCW6340PXhvKO/Zq"
				+ "4DKLfqFTpUpAkEAoJZ8Y57wAoPGhGnKDMM4+mmqo/pp6TegVJB87ybqdV/6t1YW5ocgnyHYtbQw/fiCSeHxS10a3FxX4CKg"
				+ "8hGpvQJAFzFZkhgAenXz9wY9wTIFUA36oiAF5hjIq1AxBITildaUmQRwxawf7ukbhoGtW2zEwomgYZH0u7aghrRmvEHoCQJ"
				+ "ACYqpinNqoqLHP/OtQXJb7sffwRhtNwSf7LjYJoiSsocuKV7oYwUjyllOp/GlaaLqpOfvQEg1PKaHZ4LC4h1tuA==";
		
		
		*/
		//baseUser.setPublicKey(pubKey);
		//baseUser.setPrivateKey(privKey);
		/*
		Set<String> containerSet = new HashSet<String>();
		containerSet.add(BODefaults.BASE_USER);
		containerSet.add(BODefaults.BASE_CONTAINER);
		baseUser.setContianerSet(containerSet);
		*/
		
	}
	
	private Ctx() 
	{
		
	}
	
	
	
	//static void setContext(String containerUuid, String userUuid)
	static void setContext(User user)
	{
		ctxUser.set(user);
		
		/*
		ctxUserUuid.set(userUuid);
		ctxContainerUuid.set(containerUuid);
		
		User user = new User();
		user.setBaseUuid(BASE_USER);
		user.setVersionNumber(1);
		user.setVersionUuid(BASE_USER);
		user.setLatestVersionUuid(BASE_USER);
		user.setContainerUuid(BASE_CONTAINER);
		user.setCreatedBy(BASE_USER);
		ctxUser.set(user);
		
		Container container = new Container();
		container.setBaseUuid(BASE_CONTAINER);
		container.setVersionNumber(1);
		container.setVersionUuid(BASE_CONTAINER);
		container.setLatestVersionUuid(BASE_CONTAINER);
		container.setContainerUuid(BASE_CONTAINER);
		container.setCreatedBy(BASE_USER);
		ctxContainer.set(container);
		*/
	}
	
	public static String[] getContainers()
	{
		//return new String[]{ctxUser.get().getContainerUuid(), BODefaults.BASE_CONTAINER, BODefaults.BASE_USER};
		if(ctxUser != null && ctxUser.get() != null)
		{
			return new String[]{ctxUser.get().getBaseUuid(), BODefaults.BASE_CONTAINER, BODefaults.BASE_USER};
		}
		else
		{
			return new String[]{BODefaults.BASE_CONTAINER, BODefaults.BASE_USER};
		}
	}
	
	public static String getUserUuid()
	{
		if(ctxUser.get() == null)
		{
			return BODefaults.BASE_USER;
		}
		else
		{
			return ctxUser.get().getBaseUuid();
		}
	}
	
	public static User getUser()
	{
		if(ctxUser.get() == null)
		{
			return baseUser;
		}
		else
		{
			return ctxUser.get();
		}
	}
	
	public static User getBaseUser()
	{
		return baseUser;
	}
	
	public static String getError() 
	{
		return ctxError.get();
	}



	
	public static void setError(String error) 
	{
		ctxError.set(error);
	}
	
	
	 
	public static void cleanup()
	{
		ctxUser.remove();
		ctxError.remove();
	}
	
}
