package io.baltoro.service;

import java.util.HashMap;
import java.util.Map;

import io.baltoro.domain.Alias;
import io.baltoro.domain.BO;
import io.baltoro.domain.ObjectTypeEnum;

public class BOCache
{
	private static BOCache cache;
	
	private Map<String, BO> map = new HashMap<>(2000);
	private Map<String, String> nameUuidMap = new HashMap<>(2000);
	
	private BOCache()
	{
		
	}
	
	static BOCache instance()
	{
		if(cache == null)
		{
			cache = new BOCache();
		}
		return cache;
	}
	
	
	
	void add(String uuid, BO bo)
	{
		map.put(uuid, bo);
		String key = bo.getName()+"-"+bo.getObjectType();
		String destUuid = bo.getBaseUuid();
		
		if(bo instanceof Alias)
		{
			Alias alias = (Alias) bo;
			key = bo.getName()+"-"+alias.getSourceType()+"-"+ObjectTypeEnum.ALIS;
			destUuid = alias.getSourceUuid();
					
		}
		nameUuidMap.put(key,destUuid);
	}
	
	BO get(String uuid)
	{
		return map.get(uuid);
	}
	
	BO getByName(String name, ObjectTypeEnum type)
	{
		String key = name+"-"+type;
		String baseUuid = nameUuidMap.get(key);
		if(baseUuid == null)
		{
			key = name+"-"+type+"-"+ObjectTypeEnum.ALIS;
			baseUuid = nameUuidMap.get(key);
			if(baseUuid == null)
			{
				return null;
			}
		}
		BO bo = map.get(baseUuid);
		return bo;
	}
	
	void remove(String uuid)
	{
		map.remove(uuid);
	}
	
}
