package io.baltoro.remote.api;

import java.io.Writer;
import java.util.concurrent.ConcurrentLinkedQueue;

import javax.ws.rs.Path;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

import io.baltoro.exception.ServiceException;
import io.baltoro.service.Ctx;
import io.baltoro.util.StringUtil;


@Path("/poll")
public class APIClientPool extends APIBase
{

	static Log log = LogFactory.getLog(APIClientPool.class);
	
	@Override
	void init() 
	{
		
	}
	

	
	
	public void process()
	throws ServiceException, Exception
	{
		try
		{
		
			Ctx ctx  = null;//getServiceContext();
			
			String mbSessionId = null;//ctx.getSessionId();
			if(StringUtil.isNullOrEmpty(mbSessionId))
			{
				throw new ServiceException("No valid sessionId found in the cookie");
			}
				
			ConcurrentLinkedQueue<String> pollingQueue = null;//ClientPool.getInstance().getRequestQueue(mbSessionId);
			
			if(pollingQueue.isEmpty())
	    	{
	    		synchronized (mbSessionId.intern())
				{
	    			try
					{
	    				mbSessionId.intern().wait(30000);
	    				
					}
					catch (InterruptedException e)
					{
						log.error("error", e);
					}
				}
	    	}
	    	
			
			Writer writer =  null;//response.getWriter();
			if(pollingQueue != null && pollingQueue.size() > 0)
	    	{
	    		String query = null;
	    		while((query = pollingQueue.poll()) != null)
	    		{
	    			writer.write(query+"\r\n");
	        	    log.debug("md polling ("+mbSessionId+":)*********** Polling send: " + query);
				}
	     	}
			else
			{
				log.info("***** ++++++++++++ ****** No Polling send: ");
			}
		}
		catch(Exception e)
		{
			//response.setHeader("Error", "error");
			log.error("error", e);
		}
		  
	}
	
}
