package io.baltoro.remote;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkerPool
{

	private static ConcurrentLinkedQueue<RequestWorker> free = new ConcurrentLinkedQueue<>();
	private static Set<RequestWorker> busy = new HashSet<>();
	
	static RequestWorker get()
	{
		if(free.size() == 0)
		{
			return null;
		}
		
		
		RequestWorker worker = free.poll();
		busy.add(worker);
		return worker;
	}
	
	static void done(RequestWorker worker)
	{
		worker.clear();
		busy.remove(worker);
		free.add(worker);
	}
	

	static String info()
	{
		return "free : "+free.size()+" busy : "+busy.toArray().length;
	}
	
}
