package io.baltoro.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;

import javax.websocket.Session;

public class WSSessionPool
{

	private static Map<String, WSSessionPool> sessionMap = new HashMap<String, WSSessionPool>(500);
	private ConcurrentLinkedDeque<Session> sessionQueue;		
	
	private WSSessionPool()
	{
		sessionQueue = new ConcurrentLinkedDeque<>();
	}
	
	
	static WSSessionPool get(String instanceUuid)
	{
		
		WSSessionPool pool = sessionMap.get(instanceUuid);
		if(pool == null)
		{
			pool = new WSSessionPool();
			sessionMap.put(instanceUuid, pool);
		}
		
		return pool;
	}
	
	void addSession(Session session)
	{
		sessionQueue.add(session);
	}
	
	Session getSession()
	{
		return sessionQueue.poll();
	}
}
