package io.baltoro.remote;

import java.util.HashMap;
import java.util.Map;

import io.baltoro.domain.AppUserSession;

public class SessionCache
{
	private static SessionCache _instance;
	private Map<String, AppUserSession> map;

	private SessionCache()
	{
		map = new HashMap<>(1000);
	}
	
	
	
	public static SessionCache get()
	{
		if(_instance == null)
		{
			_instance = new SessionCache();
		}
		
		return _instance;
	}
	
	public void add(String uuid, AppUserSession obj)
	{
		map.put(uuid, obj);
	}
	
	public void remove(String uuid)
	{
		map.remove(uuid);
	}
	
	public AppUserSession get(String uuid)
	{
		AppUserSession obj = map.get(uuid);
		return obj;
	}
}
