package io.baltoro.remote;

import java.io.IOException;
import java.sql.Timestamp;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.glassfish.jersey.servlet.ServletContainer;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.domain.App;
import io.baltoro.domain.AppUserSession;
import io.baltoro.domain.BaltoroAppAPI;
import io.baltoro.domain.BaltoroInstanceRequest;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.service.Service;
import io.baltoro.service.ServiceFactory;
import io.baltoro.util.StringUtil;



public class RootServlet extends ServletContainer
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	static Log log = LogFactory.getLog(RootServlet.class);
	static ObjectMapper objectMapper = new ObjectMapper();
	
	static final String BLTC_CLIENT = "BLCT4B0F12FA974043E3BB23D485237EAB64".toLowerCase();
	
	

	@Override
	public void init(ServletConfig config) throws ServletException
	{
		log.info("/////////////////////////////");
		log.info("/////////[Starting Root Servlet]///////////");
		log.info("/////////////////////////////");
		
		super.init(config);
	}
	
	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
			
		String protocol = request.getRequestURL().toString();
		
		System.out.println("============>   protocol : "+protocol);
		
		String blClientHost = request.getHeader("BLT_INST_SERVER_HOST");
		if(StringUtil.isNotNullAndNotEmpty(blClientHost) && blClientHost.equals(BLTC_CLIENT))
		{
			try
			{
				boolean rtn = BLClientHandler.process(request, response);
				if(rtn)
				{
					return;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				return;
			}
		}
		
		  
		String appName = null;
	    String serverName = request.getServerName();
	 
	    
	    lhost : if(serverName.equals("localhost") || serverName.equals("127.0.0.1"))
	    {
	  
	    	appName = request.getParameter("appName");
    		if(StringUtil.isNotNullAndNotEmpty(appName))
    		{
    			response.addCookie(new Cookie("BLT_APP_NAME_LOC", appName));
    			response.sendRedirect("http://localhost:8080");
    			return;
    			//break lhost;
    		}
    		
	    	
	    	String sURL = "usage : "+request.getRequestURL().toString()+"?appName=";
	    	Cookie[] cookies = request.getCookies();
	    	if(cookies == null)
	    	{
	    		response.getOutputStream().write(sURL.getBytes());
	    		return;
	    	}
	    	
	    	
	    	for (Cookie cookie : cookies)
			{
				if(cookie.getName().equals("BLT_APP_NAME_LOC"))
				{
					appName = cookie.getValue();
					break lhost;
				}
				
			}
    			
			response.getOutputStream().write(sURL.getBytes());
    		return;

	    }
	    else
	    {
	    	appName = serverName.substring(0,serverName.indexOf('.'));
	    }
		
		if(StringUtil.isNullOrEmpty(appName))
		{
			System.out.println("appName is null");
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		}
		
		String path = request.getRequestURI().toLowerCase();
		
		int xidx1 = path.indexOf('/', 0);
		int xidx2 = path.indexOf('/',1);
		String serviceName = null;
		
		if(xidx2 == -1)
		{
			xidx2 = path.length();
		}
		
		serviceName = path.substring(xidx1+1, xidx2);
		
		if(StringUtil.isNullOrEmpty(serviceName))
		{
			serviceName = "/";
		}
		
		
		request.getSession(true);
		  
		System.out.println("**********************************");
		System.out.println(request.getMethod()+" ["+appName+"] -- ["+serverName+"] "+path);
		System.out.println("**********************************");
	
		
		
		Service service = ServiceFactory.getInstance();
		
		App app = (App) service.getByName(appName, ObjectTypeEnum.APPW);
		if(app == null)
		{
			response.addHeader("BALTORO-ERROR", appName+ " does not exsists  "+path);
			response.getOutputStream().write( (appName+ " does not exsists  "+path).getBytes());
			return;
		}
		

		
		SessionInstance sessionInstance = BLTRequest.getSessionInstance(app, serviceName, request, response);
		if(sessionInstance == null)
		{
			response.addHeader("BALTORO-ERROR", "App Node is not up !! "+path);
			response.getOutputStream().write( ("App Node ["+appName+"] is not up !! "+path).getBytes());
			return;
		}
		
		
		AppUserSession appUserSession = BLTRequest.getAppUserSession(sessionInstance, request, response);
		
		CachePathMap pathCache = CachePathMap.get();
		BaltoroAppAPI api = pathCache.getBaltoroAppPath(app.getBaseUuid(), path);
		
		if(api == null)
		{
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "resource not found");
			return;
		}
		
		System.out.println("==== > "+api.getUuid()+" ,,, "+path);
		
		
		   
		BaltoroInstanceRequest req = BaltoroInstanceRequest.get();
		req.setAppUuid(app.getBaseUuid());
		req.setAPIUuid(api.getUuid());
		req.setAppUuid(sessionInstance.getAppUuid());
		req.setAddPath(path);
		req.setInstanceUuid(sessionInstance.getInstanceUuid());
		req.setSizeKB(-1);
		req.setBltSessionId(appUserSession.getUuid());

		
		long t0 = System.currentTimeMillis();
		req.setStartedOn(new Timestamp(t0));
		
		BaltoroReqProcessor.get().add(req);
		
		
		try
		{
			byte[] bytes = BLTRequest.processAppRequest(sessionInstance, appUserSession, api, appName, serviceName, path, request, response);
			if(bytes != null)
			{
				response.getOutputStream().write(bytes);
				//response.addHeader("Content-Length", ""+bytes.length);
				int size = bytes.length/1000 == 0 ? 1 : bytes.length/1000;
				req.setSizeKB(size);
			}
			else
			{
				System.out.println(path+" source not modified !!! ");
			}
		
			
		} 
		/*
		catch (ServiceException e)
		{
			e.printStackTrace();
			//log.info(" ------------------------- "+e.getMessage());
			req.setError(e.getMessage());
			
		}
		*/
		catch (Exception e)
		{
			e.printStackTrace();
			req.setError(e.getMessage());
			byte[] bytes = e.getMessage().getBytes();
			response.getOutputStream().write(bytes);
			int size = bytes.length/1000 == 0 ? 1 : bytes.length/1000;
			req.setSizeKB(size);
		}
		
	
		req.setMillisTaken((int)(System.currentTimeMillis() - t0));
		BaltoroReqProcessor.get().update(req);
		
		
	}
	
	
		
	
	
	
	
	
	
	
}
