package io.baltoro.remote;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.domain.BODefaults;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.WSTO;

public class PollServer
{

	private static Log log = LogFactory.getLog(PollServer.class);
	private static PollServer pollServer;
	private static ConcurrentLinkedQueue<BaltoroInstance> heartBeatQueue = new ConcurrentLinkedQueue<>();
	private static Map<String,BaltoroInstance> heartBeatDamper = new HashMap<>(500);
	
	private Map<String, ConcurrentLinkedQueue<WSTO>> pollMap = new HashMap<>(500);
	static ObjectMapper mapper = new ObjectMapper();
	private String localName = null;
	private InstanceService service = ServiceFactory.get(InstanceService.class);
	
	private Timer instMonitor;
	
	
	
	private PollServer()
	{
		try
		{
			localName =  Optional.ofNullable(InetAddress.getLocalHost().getHostName()).orElse(InetAddress.getLocalHost().getHostAddress());
			
			instMonitor = new Timer();
			instMonitor.schedule(new TimerTask()
			{
				
				@Override
				public void run()
				{
					log.info("############################### close dead inst ");
					monitorInst();
						
				}
			}, 5000, 5000);
				
			
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
		
	}
	
	public static PollServer get()
	{
		if(pollServer == null)
		{
			pollServer = new PollServer();
			
		}
		
		return pollServer;
	}
	
	
	public void monitorInst()
	{
		
		try
		{
			
			saveHeartBeat();
			
			List<String> list = service.findDeadInstances();
			for (String uuid : list)
			{
				log.info("cleaning ...... pollMap >>>>>> "+uuid);
				pollMap.remove(uuid);
			}
			
			service.closeDeadInstances();

			
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
			
		
		
	}
	

	private ConcurrentLinkedQueue<WSTO> getQueue(String instanceUuid)
	{
		ConcurrentLinkedQueue<WSTO> queue = pollMap.get(instanceUuid);
		if(queue == null)
		{
			String sync = instanceUuid+"-pollqueue";
			synchronized (sync.intern())
			{
				queue = pollMap.get(instanceUuid);
				if(queue == null)
				{
					queue = new ConcurrentLinkedQueue<>();
					pollMap.put(instanceUuid, queue);
					
				}
			}
			
		}
		
		
		return queue;
	}
	
	public void sendWSTO(WSTO to)
	{
	
		ConcurrentLinkedQueue<WSTO> queue = getQueue(to.instanceUuid);
		queue.add(to);
		
		String sync = to.instanceUuid+"-instQueue";
		synchronized (sync.intern())
		{
			sync.intern().notify();
		}
		
	}
	
	public void hold(HttpServletRequest req, HttpServletResponse res)
	{
		
		String appName = req.getHeader("BLT_APP_NAME");
		
		BaltoroInstance inst = handleInstanceCall(req, res);
		
			
		ConcurrentLinkedQueue<WSTO> queue = getQueue(inst.getUuid());
		if(queue.isEmpty())
		{
			try
			{
				String sync = inst.getUuid()+"-instQueue";
				synchronized (sync.intern())
				{
					sync.intern().wait(10000);
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		
		log.info(" +++++++++++++++++++++++++++++++++++++++++++++++++++++  poll queue : "+queue.size());
		
		if(!queue.isEmpty())
		{
			boolean has = true;
		
			List<WSTO> list = new ArrayList<>(100);
			while(has || list.size() >= 100)
			{
				WSTO to = queue.poll();
				if(to == null)
				{
					has = false;
					break;
				}
				
				log.info(" =     ^^^^^   ==> "+to.uuid);
				list.add(to);
			}
			
			try
			{
				byte[] out = mapper.writeValueAsBytes(list);
				
				res.getOutputStream().write(out);
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		
		
		
	}
	
	
	SessionInstance getSession(String appUuid, String appName, String serviceName, String instanceUuid)
	{
		//String key = appName+"-"+serviceName;
		ConcurrentLinkedQueue<WSTO> queue = pollMap.get(instanceUuid);
		
		if(queue != null)
		{
			return new SessionInstance(appUuid, appName, serviceName, instanceUuid);	
		}
		
		
		
		String instUuid = null;
		try
		{
			instUuid = service.findInstances(appUuid, serviceName);
		} 
		catch (ServiceException e)
		{
			e.printStackTrace();
		}
		
		if(instUuid == null)
		{
			return null;
		}
		
	
		return new SessionInstance(appUuid, appName, serviceName, instUuid);	
		
	}
	
	/*
	String getRunningInstanceUuid(HttpServletRequest req, HttpServletResponse res)
	{
		String instanceUuid = req.getHeader("BLT_INSTANCE_UUID");
		long lat = pollTracker.get(instanceUuid);
		
		
		
		if(lat == 0)
		{
			
		}
		
		
		if((System.currentTimeMillis() - lat) < 10000)
		{
			return instanceUuid;
		}
		
		return instanceUuid;
	}
	*/
	
	private BaltoroInstance handleInstanceCall(HttpServletRequest req, HttpServletResponse res)
	{
		
		String path1 = req.getRequestURI();
		String path2 = req.getRequestURL().toString();
		
		String eToken = req.getHeader("BLT_TOKEN");
		String appName = req.getHeader("BLT_APP_NAME");
		
		
		String appUuid = req.getHeader("BLT_APP_UUID");
		String instanceUuid = req.getHeader("BLT_INSTANCE_UUID");
		String serviceName = req.getHeader("BLT_SERVICE_NAME");
		String remoteHost = req.getRemoteHost();
		String state = "LIVE";
		
		String cpu = req.getParameter("BLT_CPU");
		String memoryGB = req.getParameter("BLT_MEMORY_GB");

		
		BaltoroInstance inst = new BaltoroInstance();
		
		inst.setAppUuid(appUuid);
		inst.setUuid(instanceUuid);
		inst.setServiceName(serviceName);
		int _cpu = Integer.parseInt(cpu);
		inst.setCpuPercent(_cpu);
		int _memoryGB = Integer.parseInt(memoryGB);
		inst.setMemoryGB(_memoryGB);
		inst.setRemoteAddress(remoteHost);
		inst.setState(state);
		inst.setHostAddress(localName);
	
		heartBeatQueue.add(inst);
		
		return inst;
	}
		
		
	private void saveHeartBeat()
	throws Exception
	{

		boolean more = true;
		
		while (more)
		{
			BaltoroInstance inst = heartBeatQueue.poll();
			if(inst == null)
			{
				more = false;
				break;
			}
			heartBeatDamper.put(inst.getUuid(), inst);
			
		}
		
		for (BaltoroInstance inst : heartBeatDamper.values())
		{
			BaltoroInstance _inst = service.get(inst.getUuid());
			if(_inst == null)
			{
				inst.setStartedOn(new Timestamp(System.currentTimeMillis()));
				inst.setLastHeartBeatOn(inst.getStartedOn());
				inst.setCreatedBy(BODefaults.BASE_USER);
				
				service.insert(inst);
			}
			else
			{
				_inst.setLastHeartBeatOn(new Timestamp(System.currentTimeMillis()));
				service.update(inst.getUuid(), "LIVE", inst.getCpuPercent(), inst.getMemoryGB());
			}
			
			
		}
		
		heartBeatDamper.clear();
		
		/*
		if(ctx.getPathTOs() != null)
		{
			List<BaltoroAppAPI> list = service.registerAppAPI(to.instanceUuid, to.appUuid, ctx.getPathTOs());
			
			CachePathMap cache = CachePathMap.get();
			for (BaltoroAppAPI baltoroAppAPI : list)
			{
				cache.addPathUuid(app.getBaseUuid(), baltoroAppAPI);
			}
			
		}
		*/
		
	}
	
	
	
}
