package io.baltoro.remote;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import io.baltoro.domain.AppUserSession;
import io.baltoro.service.InstanceService;
import io.baltoro.service.ServiceFactory;

public class HTTPSessions implements HttpSessionListener
{
	
		private static Map<String, HttpSession> sessionMap = new HashMap<String, HttpSession>(10000);
		
	   @Override
	    public void sessionCreated(final HttpSessionEvent se) 
	   {
	        final HttpSession session = se.getSession();
	        // final ServletContext context = session.getServletContext();
	        // context.setAttribute(session.getId(), session);
	        
	        sessionMap.put(session.getId(), session);
	    }

	    @Override
	    public void sessionDestroyed(final HttpSessionEvent se) 
	    {
	        final HttpSession session = se.getSession();
	        String bltSessionId = (String) session.getAttribute("blt-session-id");
	        if(bltSessionId != null)
	        {
	        	InstanceService service = ServiceFactory.get(InstanceService.class);
	        	service.closeAppUserSession(bltSessionId);
			
	        }
	        
	        sessionMap.remove(session.getId());
	    }
	    
	    
	    static HttpSession getSession(String sessionId)
	    {
	    	return sessionMap.get(sessionId);
	    }

}
