package io.baltoro.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.baltoro.domain.BaltoroAppAPI;

public class CachePathMap
{
	private static CachePathMap _instance;
	private Map<String, BaltoroAppAPI> map;
	private Map<String, List<String>> wildCardMap;

	private CachePathMap()
	{
		map = new HashMap<>(10000);
		wildCardMap = new HashMap<>(5000);
	}
	
	
	
	public static CachePathMap get()
	{
		if(_instance == null)
		{
			_instance = new CachePathMap();
		}
		
		return _instance;
	}
	
	public void addPathUuid(String appUuid, BaltoroAppAPI baltoroAppPath)
	{
		String path = baltoroAppPath.getPath();
		map.put(appUuid+path, baltoroAppPath);
		
		if(path.endsWith("/*"))
		{
			List<String> list = wildCardMap.get(appUuid);
			if(list == null)
			{
				list = new ArrayList<>();
				wildCardMap.put(appUuid, list);
			}
			list.add(path.substring(0,path.length()-1));
		}
	}
	
	public BaltoroAppAPI getBaltoroAppPath(String appUuid, String path)
	{
		
		BaltoroAppAPI baltoroAppPath = map.get(appUuid+path);
		if(baltoroAppPath != null)
		{	
			return baltoroAppPath; 
		}
		
		List<String> wPaths = wildCardMap.get(appUuid);
		if(wPaths == null)
		{
			return null;
		}
		
		
		for (String wPath : wildCardMap.get(appUuid))
		{
			if(path.startsWith(wPath))
			{
				baltoroAppPath = map.get(appUuid+wPath+"*");
				if(baltoroAppPath != null)
				{
					return baltoroAppPath;
				}
			}
		}
		
		
		return null;
		
	}
}
