package io.baltoro.remote;

import java.io.IOException;
import java.security.Security;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import io.baltoro.exception.ServiceException;
import io.baltoro.service.Ctx;


public abstract class BaseFilter implements Filter
{

	static
	{
		Security.addProvider(new BouncyCastleProvider());
	}
	protected static final Log log = LogFactory.getLog(BaseFilter.class);
	protected FilterConfig filterConfig;
	
	
	
	public void init(FilterConfig filterConfig) throws ServletException
	{
		this.filterConfig = filterConfig;
	}
	
	public final void doFilter(ServletRequest req, ServletResponse res,FilterChain chain) 
	throws IOException, ServletException
	{
		HttpServletResponse response = (HttpServletResponse) res;
		HttpServletRequest request = (HttpServletRequest) req;
	
		Ctx.cleanup();
		try
		{
			processFilter(request, response, chain);
		}
		finally
		{
			Ctx.cleanup();
		}
		
	}
	
	
	public abstract void processFilter(HttpServletRequest req, HttpServletResponse res,FilterChain chain) 
	throws IOException, ServletException;
	
	
	public void destroy()
	{
		filterConfig = null;
	}
	
	
	
}