package io.baltoro.remote;

import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.domain.App;
import io.baltoro.domain.BaltoroAppAPI;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.domain.PrivateData;
import io.baltoro.domain.User;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.Service;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.PathTO;
import io.baltoro.to.ReplicationTO;
import io.baltoro.to.WSTO;

public class BLClientHandler
{
	

	static final String POLL_SERVICE = "/PLSV93CA659B1BEB4229B49FF44852DA462F".toLowerCase();
	static final String RESP_SERVICE = "/RSSVA0BE926D318342BD9939D7AC06FE9A9B".toLowerCase();
	

	static ObjectMapper objectMapper = new ObjectMapper();
	
	static Log log = LogFactory.getLog(BLClientHandler.class);
	
	BLClientHandler()
	{
		
	}
	
	
	static boolean process(HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		String path = request.getRequestURI().toLowerCase();
		
		
		if(path.equals(POLL_SERVICE))
		{
			PollServer ps = PollServer.get();
			ps.hold(request, response);
			
			return true;
		}
		
		if(path.equals(RESP_SERVICE))
		{
			
			String toUuid = request.getParameter("to-uuid");
			String json = request.getParameter("json");
			
			WSTO to = objectMapper.readValue(json, WSTO.class);
			
			log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  uuid-->"+toUuid+", data --- >"+to.responseContext.getData());
			
			ResponseMap.getInstance().add(toUuid, to);
			
			synchronized (toUuid.intern())
			{
				toUuid.intern().notify();
			}
			
			return true;
		}
		
		
		if(path.equals("/areyouthere"))
		{
			response.getWriter().write(""+System.currentTimeMillis());
			return true;
		}
		
		if(path.equals("/getremaininginsancethreadscount"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			int allowedCount = helper.getAllowedThreadPerInstance();
			response.getWriter().write(""+allowedCount);
			return true;
		}
		
		if(path.equals("/createinstance"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			String allowed = helper.createInstance();
			response.getWriter().write(allowed);
			return true;
		}
		
		if(path.equals("/instancecreated"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			String allowed = helper.instanceCreated();
			response.getWriter().write(allowed);
			return true;
		}
		
		
		if(path.equals("/createuser"))
		{
			Service service = ServiceFactory.getInstance();
			String email = request.getParameter("email");
			String password = request.getParameter("password");
			
			
			try
			{
				User user = service.createUser(email, password);
				response.getOutputStream().write(user.getBaseUuid().getBytes());
			} 
			catch (ServiceException e)
			{
				e.printStackTrace();
			}
			
			return true;
		}
		
		
		if(path.equals("/setappapi"))
		{
			
			String json = request.getParameter("json");
			String instUuid = request.getParameter("inst-uuid");
			String appUuid = request.getParameter("app-uuid");
					
			PathTO[] apis = new ObjectMapper().readValue(json, PathTO[].class);
			
			List<PathTO> apiListy = Arrays.asList(apis);
		
			InstanceService service = ServiceFactory.get(InstanceService.class);
			
			List<BaltoroAppAPI> list = null;
			try
			{
				list = service.registerAppAPI(instUuid, appUuid, apiListy);
			} 
			catch (ServiceException e)
			{
				e.printStackTrace();
			}
			
			CachePathMap cache = CachePathMap.get();
			for (BaltoroAppAPI baltoroAppAPI : list)
			{
				cache.addPathUuid(appUuid, baltoroAppAPI);
			}
			
			
			return true;
		}
		
		if(path.equals("/getreplication"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			ReplicationTO to = helper.getReplication();
			String json = objectMapper.writeValueAsString(to);

			response.setContentType("application/json");
			response.getWriter().write(json);
			return true;
		}
		
		if(path.equals("/favicon.ico"))
		{
			//super.service(request, response);
			return true;
		}
		
		
		Service service = ServiceFactory.getInstance();
		
		
		if(path.equals("/getappuuidbyname"))
		{
			String _appName = request.getParameter("app-name");
			App app = (App) service.getByName(_appName, ObjectTypeEnum.APPW);
			if(app == null)
			{
				try
				{
					app = service.createApp(_appName);
				} 
				catch (ServiceException e)
				{
					e.printStackTrace();
				}
			}
			response.getWriter().write(""+app.getBaseUuid());
			return true;
		}
		
		if(path.equals("/getappdata"))
		{
			try
			{
				String pdUuid = request.getParameter("app-uuid");
				PrivateData pd = (PrivateData) service.getByName(pdUuid+"-private data", ObjectTypeEnum.PRVD);
				if(pd == null)
				{
					response.getWriter().write("No found");
					return true;
				}
				
				response.getWriter().write(pd.getPrivateKey());
				return true;
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				response.getWriter().write("Error !!!! ");
				return true;
			}
			
		}
		
		
		
		
		return true;
	}
}
