package io.baltoro.domain;

import java.sql.Timestamp;

import io.baltoro.util.UUIDGenerator;

public class BaltoroInstanceRequest
{
	private String uuid;
	private String instanceUuid;
	private String appUuid;
	private String apiUuid;
	private String addPath;
	private Timestamp startedOn;
	private int millisTaken = -1;
	private String createdBy;
	private int sizeKB;
	private String error;
	private String bltSessionId;

	
	
	public static BaltoroInstanceRequest get()
	{
		BaltoroInstanceRequest req = new BaltoroInstanceRequest();
		req.setUuid(UUIDGenerator.uuid("INRQ"));
		req.setStartedOn(new Timestamp(System.currentTimeMillis()));
		req.setCreatedBy(BODefaults.BASE_USER);
		return req;
	}
	
	
	
	public String getUuid()
	{
		return uuid;
	}
	public void setUuid(String uuid)
	{
		this.uuid = uuid;
	}
	public String getInstanceUuid()
	{
		return instanceUuid;
	}
	public void setInstanceUuid(String instanceUuid)
	{
		this.instanceUuid = instanceUuid;
	}
	public String getAPIUuid()
	{
		return apiUuid;
	}
	public void setAPIUuid(String apiUuid)
	{
		this.apiUuid = apiUuid;
	}
	public Timestamp getStartedOn()
	{
		return startedOn;
	}
	public void setStartedOn(Timestamp startedOn)
	{
		this.startedOn = startedOn;
	}
	public int getMillisTaken()
	{
		return millisTaken;
	}
	public void setMillisTaken(int millisTaken)
	{
		this.millisTaken = millisTaken;
	}
	public String getCreatedBy()
	{
		return createdBy;
	}
	public void setCreatedBy(String createdBy)
	{
		this.createdBy = createdBy;
	}
	public String getAddPath()
	{
		return addPath;
	}
	public void setAddPath(String addPath)
	{
		this.addPath = addPath;
	}



	public int getSizeKB()
	{
		return sizeKB;
	}



	public void setSizeKB(int sizeKB)
	{
		this.sizeKB = sizeKB;
	}



	public String getError()
	{
		return error;
	}



	public void setError(String error)
	{
		this.error = error;
	}



	public String getBltSessionId()
	{
		return bltSessionId;
	}



	public void setBltSessionId(String bltSessionId)
	{
		this.bltSessionId = bltSessionId;
	}



	public String getAppUuid()
	{
		return appUuid;
	}



	public void setAppUuid(String appUuid)
	{
		this.appUuid = appUuid;
	}
	
	
	
	
}
