/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.ResponseQueue;
import io.baltoro.client.SendRedirect;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WSAPIClassInstance;
import io.baltoro.client.WSSession;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.WorkerPool;
import io.baltoro.client.util.StringUtil;
import io.baltoro.exp.AuthException;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Param;
import io.baltoro.to.APIError;
import io.baltoro.to.RequestContext;
import io.baltoro.to.ResponseContext;
import io.baltoro.to.UserSessionContext;
import io.baltoro.to.WSTO;
import io.baltoro.to.WebSocketContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;

public class RequestWorker
extends Thread {
    private WSTO to;
    UserSession userSession;
    List<AbstractFilter> filters = new ArrayList<AbstractFilter>();
    static ObjectMapper mapper = new ObjectMapper();
    boolean run = true;
    static int _count;
    int count;
    long lastWorked = System.currentTimeMillis();
    static ThreadLocal<String> userSessionIdCtx;

    RequestWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(WSTO to) {
        this.to = to;
        RequestWorker requestWorker = this;
        synchronized (requestWorker) {
            this.notify();
        }
    }

    void clear() {
        this.to = null;
        this.userSession = null;
        this.filters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            if (this.to == null) {
                RequestWorker requestWorker = this;
                synchronized (requestWorker) {
                    try {
                        this.wait(10000L);
                        if (this.to == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                this.work();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.lastWorked = System.currentTimeMillis();
                this.to = null;
                WorkerPool.done(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        if (this.to == null) {
            System.out.println("ERROR PARSING WSTO !!!!!!! CHECK ");
            return;
        }
        RequestContext req = this.to.requestContext;
        ResponseContext res = new ResponseContext();
        res.setHeaders(new HashMap<String, String>());
        this.to.responseContext = res;
        res.setSessionId(req.getSessionId());
        userSessionIdCtx.set(req.getSessionId());
        try {
            this.process();
        }
        catch (Exception e) {
            if (e instanceof SendRedirect) {
                SendRedirect sd = (SendRedirect)e;
                res.setRedirect(sd.getUrl());
            } else if (e.getCause() instanceof SendRedirect) {
                SendRedirect sd = (SendRedirect)e.getCause();
                res.setRedirect(sd.getUrl());
            } else if (e instanceof APIError) {
                APIError er = (APIError)e;
                res.setError(er.getMessage());
            } else if (e.getCause() instanceof APIError) {
                APIError er = (APIError)e.getCause();
                res.setRedirect(er.getMessage());
            } else if (e instanceof AuthException) {
                res.setError(e.getMessage());
            } else {
                e.printStackTrace();
                res.setError(e.getMessage() + "---" + (e.getCause() != null ? e.getCause().getMessage() : ""));
            }
        }
        finally {
            ResponseQueue.instance().addToResponseQueue(this.to);
        }
    }

    private void process() throws Exception {
        RequestContext req = this.to.requestContext;
        ResponseContext res = this.to.responseContext;
        if (StringUtil.isNotNullAndNotEmpty(req.getSessionId())) {
            String reqSessionId = req.getSessionId();
            this.userSession = SessionManager.getSession(reqSessionId);
            UserSessionContext uctx = this.to.userSessionContext;
            if (uctx != null) {
                String userName;
                this.userSession.userName = userName = uctx.getPrincipalName();
                Map attMap = new HashMap();
                try {
                    if (uctx.getAttJson() != null) {
                        attMap = mapper.readValue(uctx.getAttJson(), Map.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (String key : attMap.keySet()) {
                    String val = (String)attMap.get(key);
                    this.userSession.attMap.put(key, val);
                }
            }
        }
        List<String> filterNames = WebMethodMap.getInstance().getFilterNames();
        for (String fNames : filterNames) {
            Class<AbstractFilter> _class = WebMethodMap.getInstance().getFilterClass(fNames);
            try {
                AbstractFilter filter = _class.newInstance();
                this.filters.add(filter);
                filter.before(this.to, this.userSession);
            }
            catch (Exception e) {
                SendRedirect sd;
                if (e instanceof SendRedirect) {
                    sd = (SendRedirect)e;
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e.getCause() instanceof SendRedirect) {
                    sd = (SendRedirect)e.getCause();
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e instanceof AuthException) {
                    res.setError(e.getMessage());
                    return;
                }
                e.printStackTrace();
            }
        }
        String url = req.getApiPath();
        WebMethod wm = WebMethodMap.getInstance().getMethod(url);
        if (wm == null) {
            String path = req.getApiPath();
            String[] tokens = path.split("/");
            for (int i = 0; i < tokens.length; ++i) {
                int lIndex = path.lastIndexOf(47);
                if (lIndex == -1) {
                    System.out.println("no index found / error path=" + path);
                }
                path = path.substring(0, lIndex);
                String lPath = req.getApiPath().substring(lIndex + 1);
                wm = WebMethodMap.getInstance().getMethod(path + "/*");
                if (wm == null) continue;
                req.setRelativePath(lPath);
                break;
            }
        }
        if (wm == null) {
            res.setError("API for path [" + req.getApiPath() + "] not found ");
        }
        this.checkAuth(wm, this.to, wm.getWebPath());
        Object returnObj = this.executeMethod(wm, this.to);
        for (AbstractFilter filter : this.filters) {
            filter.after(returnObj, this.to, this.userSession);
        }
        if (returnObj != null) {
            if (returnObj instanceof String) {
                this.to.responseContext.setData(((String)returnObj).getBytes());
            } else if (returnObj instanceof byte[]) {
                this.to.responseContext.setData((byte[])returnObj);
            } else {
                this.to.responseContext.setData(mapper.writeValueAsBytes(returnObj));
            }
        }
    }

    private void checkAuth(WebMethod wm, WSTO to, String path) throws AuthException {
        if (!wm.authRequired) {
            return;
        }
        String sessionId = to.requestContext.getSessionId();
        if (sessionId == null) {
            throw new AuthException("sessionId is null, cannot execute " + path);
        }
        UserSession userSession = Baltoro.getUserSession();
        if (userSession == null) {
            throw new AuthException("session object is null, cannot execute " + path);
        }
        String userName = userSession.getUserName();
        if (userName == null) {
            throw new AuthException("no auth user in session, cannot execute " + path);
        }
    }

    private Object executeMethod(WebMethod wMethod, WSTO to) throws Exception {
        Map<String, String[]> requestParam;
        RequestContext reqCtx = to.requestContext;
        ResponseContext resCtx = to.responseContext;
        WebSocketContext wsCtx = to.webSocketContext;
        WSSession wssession = null;
        if (wsCtx != null && (wssession = (WSSession)WSAPIClassInstance.get().get(wsCtx.getInitRequestUuid(), WSSession.class)) == null) {
            wssession = new WSSession(to);
        }
        Map<String, String[]> map = requestParam = reqCtx == null ? null : reqCtx.getRequestParams();
        if (requestParam == null || requestParam.size() == 0) {
            requestParam = new HashMap<String, String[]>();
        }
        Class<?> _class = wMethod.get_class();
        Method method = wMethod.getMethod();
        Parameter[] methodParms = method.getParameters();
        Object[] methodInputData = new Object[methodParms.length];
        for (int i = 0; i < methodParms.length; ++i) {
            Parameter param = methodParms[i];
            Class<?> paramClass = param.getType();
            String annoName = null;
            Annotation[] annos = param.getAnnotations();
            for (int j = 0; j < annos.length; ++j) {
                Annotation anno = annos[j];
                if (anno.annotationType() != Param.class) continue;
                Param annoPraram = (Param)anno;
                annoName = annoPraram.value();
                break;
            }
            String[] requestValue = requestParam.get(annoName);
            if (annoName != null && requestValue == null) {
                StringBuffer buffer = new StringBuffer();
                for (String paramName : requestParam.keySet()) {
                    buffer.append(paramName + ",");
                }
                throw new Exception(annoName + " is not submitted as a parameter. incoming params [" + buffer.toString() + "] ");
            }
            if (annoName != null) {
                if (paramClass == String.class && requestValue != null) {
                    methodInputData[i] = requestValue[0];
                } else if (paramClass == String[].class && requestValue != null) {
                    methodInputData[i] = requestValue;
                }
            } else if (paramClass == RequestContext.class) {
                methodInputData[i] = reqCtx;
            } else if (paramClass == ResponseContext.class) {
                methodInputData[i] = resCtx;
            } else if (paramClass == WebSocketContext.class) {
                methodInputData[i] = wsCtx;
            } else if (paramClass == UserSession.class) {
                methodInputData[i] = this.userSession;
            } else if (paramClass == WSSession.class) {
                methodInputData[i] = wssession;
            }
            if (paramClass == byte[].class && wsCtx != null && wsCtx.getApiPath().endsWith("onmessage")) {
                methodInputData[i] = wsCtx.getData();
            }
            if (paramClass != String.class || wsCtx == null || !wsCtx.getApiPath().endsWith("onmessage")) continue;
            methodInputData[i] = wsCtx.getMessage();
        }
        Object classInstance = null;
        if (wMethod.isWebSocket()) {
            if (method.isAnnotationPresent(OnOpen.class)) {
                classInstance = _class.newInstance();
                WSAPIClassInstance.get().add(wsCtx.getInitRequestUuid(), _class, classInstance);
                WSAPIClassInstance.get().add(wsCtx.getInitRequestUuid(), WSSession.class, wssession);
                WSAPIClassInstance.get().add(wsCtx.getInitRequestUuid(), WSTO.class, to);
                System.out.println("classInstance cache OnOPen " + wsCtx.getInitRequestUuid() + " - " + _class + " - " + wsCtx.getWsSessionUuid());
            }
            classInstance = WSAPIClassInstance.get().get(wsCtx.getInitRequestUuid(), _class);
            if (method.isAnnotationPresent(OnClose.class)) {
                WSAPIClassInstance.get().remove(wsCtx.getInitRequestUuid(), _class);
                WSAPIClassInstance.get().remove(wsCtx.getInitRequestUuid(), WSSession.class);
                WSAPIClassInstance.get().remove(wsCtx.getInitRequestUuid(), WSTO.class);
            }
        } else {
            classInstance = _class.newInstance();
        }
        if (classInstance == null) {
            System.out.println("classInstance is null why ? " + wsCtx.getInitRequestUuid() + " - " + _class);
            return null;
        }
        Object returnObj = method.invoke(classInstance, methodInputData);
        return returnObj;
    }

    static {
        userSessionIdCtx = new ThreadLocal();
    }
}

