package io.baltoro.remote;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import io.baltoro.exception.NoRunningInstanceException;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.WSTO;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.StringUtil;


public class WSSessions
{

	private static WSSessions sessions;
	
	private Map<String, Set<SessionInstance>> sessionAppMap;
	private Map<String, InstancePoller> pollerMap;
	
	
	
	private WSSessions()
	{
		sessionAppMap = new HashMap<>(300);
		pollerMap = new HashMap<>(300);

	}
	
	public static WSSessions get()
	{
		if(sessions == null)
		{
			sessions = new WSSessions();
		}
		return sessions;
	}
	
	
	public void addSession(SessionInstance instance, String appName, String serviceName)
	{
		
		String[] sNames = serviceName.split(",");
		for (int i = 0; i < sNames.length; i++)
		{
			String key = appName+"-"+sNames[i];
			
			System.out.println(" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ "+key+" ~~~~~~~~~~~~~ "+instance.getInstanceUuid());
			Set<SessionInstance> set = sessionAppMap.get(key);
			if(set == null)
			{
				String sync = key+"-sessions";
				synchronized(sync.intern())
				{
					set = sessionAppMap.get(key);
					if(set == null)
					{
						set = new HashSet<>();
						sessionAppMap.put(key, set);
					}
				}
				
			}
			set.add(instance);
			
			InstancePoller poller = pollerMap.get(key);
			if(poller == null)
			{
				String sync = key+"-queue";
				synchronized (sync.intern())
				{
					poller = pollerMap.get(key);
					if(poller == null)
					{
						poller = new InstancePoller(key);
						pollerMap.put(key, poller);
						poller.start();
					}
				}
			}
		}
		
	}

	/*
	public void addSession(SessionInstance instance)
	{
		
		String appUuid = instance.getAppUuid();
		
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		if(set == null)
		{
			set = new HashSet<>();
			sessionAppMap.put(appUuid, set);
		}
		set.add(instance);
		
		
		InstancePoller poller = pollerMap.get(appUuid);
		if(poller == null)
		{
			String sync = appUuid+"-queue";
			synchronized (sync.intern())
			{
				poller = pollerMap.get(appUuid);
				if(poller == null)
				{
					poller = new InstancePoller(appUuid);
					pollerMap.put(appUuid, poller);
					poller.start();
				}
			}
		}
		
	}
	*/
	
	
	void send(WSTO to)
	{
		String key = to.appName+"-"+to.serviceName;
		String sync = key+"-queue";
		
		
		InstancePoller poller = pollerMap.get(key);
		if(poller == null || !poller.run)
		{
			synchronized (sync.intern())
			{
				poller = pollerMap.get(key);
				if(poller == null || !poller.run)
				{
					poller = new InstancePoller(key);
					pollerMap.put(key, poller);
					poller.start();
				}
			}
		}
		
		
		poller.add(to);
		
		
	}
	
	
	boolean isRunning(String appService)
	{
		Set<SessionInstance> set = sessionAppMap.get(appService);
		if(set == null || set.isEmpty())
		{
			return false;
		}
		return true;
	}
	

	int getSessionCount(String appService, String instanceUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appService);
		if(set == null)
		{
			return 0;
		}
		else
		{
			int count = 0;
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					count++;
				}
			}
			return count;
		}
	}
	
	SessionInstance getSession(String appName, String serviceName, String instanceUuid)
	{
		String key = appName+"-"+serviceName;
		Set<SessionInstance> set = sessionAppMap.get(key);
		
		if(StringUtil.isNullOrEmpty(set))
		{
			key = appName+"-*";
			set = sessionAppMap.get(key);
		}
		
		if(StringUtil.isNullOrEmpty(set))
		{
			return null;
		}
		
		if(StringUtil.isNotNullAndNotEmpty(instanceUuid))
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					return sessionInstance;
				}
			}
		}
		
		
		Optional<SessionInstance> instance = ObjectUtil.getRandom(set);
		
		return instance.orElse(set.iterator().next());
		
	}
	
	
	SessionInstance getSessionForWorker(String appService, String instanceUuid)
	throws NoRunningInstanceException
	{
		Set<SessionInstance> set = sessionAppMap.get(appService);
		
		
		
		if(StringUtil.isNullOrEmpty(set))
		{
			throw new NoRunningInstanceException(appService);
		}
			
		
		String sync = appService+"-queue";
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					if(sessionInstance.working == false)
					{
						sessionInstance.working = true;
						return sessionInstance;
					}
					
				}
			}
		}
		
		
		
		return null;
		
	}
	

	
	public void removeSession(String appService, String instanceUuid, String wsSessionId)
	{
		//sessionInstranceMap.remove(appName+"-"+instanceUuid);
		String sync = appService+"-queue";
		
		Set<SessionInstance> set = sessionAppMap.get(appService);
		SessionInstance rmInstance = null;
		int instSessionCount = -1;
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					instSessionCount++;
					if(sessionInstance.getSession().getId().equals(wsSessionId))
					{
						rmInstance = sessionInstance;
						System.out.println("removed session instance "+sessionInstance);
					}
				}
			}
			
			
			if(rmInstance != null && set != null)
			{
				set.remove(rmInstance);
			}
		}
		
		
		
		if(instSessionCount == 0)
		{
			InstanceService service = ServiceFactory.get(InstanceService.class);
			
			try
			{
				service.update(instanceUuid, "DOWN1", 0, 0);
			} 
			catch (ServiceException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			InstancePoller poller = pollerMap.get(appService);
			if(poller != null)
			{
				poller.run = false;
				pollerMap.remove(appService);
				
				synchronized (sync.intern())
				{
					sync.intern().notify();
				}
			}
		}
	}
}
