package io.baltoro.remote;
import java.security.Principal;

import javax.servlet.http.HttpSession;

public class WSPrincipal implements Principal 
{
    private final HttpSession session;
    private final String appUuid;
	private final String instanceUuid;
	private final String token;
    

    public WSPrincipal(String token, HttpSession session, String appUuid, String instanceUuid) 
    {
        this.session = session;
        this.appUuid = appUuid;
        this.instanceUuid = instanceUuid;
        this.token = token;
    }

    public HttpSession getSession() 
    {
        return session;
    }
    
    public String getAppUuid()
   	{
   		return appUuid;
   	}

    
    public String getInstanceUuid()
	{
		return instanceUuid;
	}
    


	@Override
    public String getName() 
    {
        return token;
    }
}