package io.baltoro.remote;

import javax.websocket.Session;

public class SessionInstance
{
	private final String appUuid;
	private final String instanceUuid;
	private final String appName;
	private final String serviceName;
	private final Session session;
	final long startedOn = System.currentTimeMillis();
	boolean working = false;
	
	public SessionInstance(String appUuid, String appName, String instanceUuid, Session session)
	//public SessionInstance(String appUuid, String appName, String serviceName, String instanceUuid, Session session)
	{
		this.appUuid = appUuid;
		this.instanceUuid = instanceUuid;
		this.session = session;
		this.appName = appName;
		this.serviceName = null;
	}
	
	public SessionInstance(String appUuid, String appName, String serviceName, String instanceUuid)
	{
		this.appUuid = appUuid;
		this.instanceUuid = instanceUuid;
		this.appName = appName;
		this.serviceName = serviceName;
		this.session = null;
	}

	public String getInstanceUuid()
	{
		return instanceUuid;
	}

	public Session getSession()
	{
		return session;
	}
	

	/*
	public String getServiceName()
	{
		return serviceName;
	}
	*/
	
	public String getAppUuid()
	{
		return appUuid;
	}
	
	

	public String getServiceName()
	{
		return serviceName;
	}

	public long getStartedOn()
	{
		return startedOn;
	}

	@Override
	public String toString()
	{
		//return appName+"-"+serviceName+"-"+instanceUuid+"-"+session.getId();
		return appName+"-"+instanceUuid+"-"+session.getId();
	}
	
	public int hashCode()
	{
        //return appName.hashCode() ^ serviceName.hashCode() ^ session.getId().hashCode();
        return appName.hashCode() ^ session.getId().hashCode();
    }

    public boolean equals(Object obj)
    {
    	if(obj instanceof SessionInstance)
    	{
    		SessionInstance _sess = (SessionInstance) obj;
    		//return appName.equals(_sess.appName) && serviceName.equals(_sess.serviceName) && session.getId().equals(_sess.getSession().getId());
    		return appName.equals(_sess.appName) && session.getId().equals(_sess.getSession().getId());
    	}
    	else
    	{
    		return super.equals(obj);
    	}
    }
}
