package io.baltoro.remote;

import java.util.concurrent.ConcurrentLinkedQueue;

import io.baltoro.exception.NoRunningInstanceException;
import io.baltoro.to.WSTO;

public class InstancePoller extends Thread
{
	
	private String appService;
	boolean run = true;
	private String sync;
	private long t;
	ConcurrentLinkedQueue<WSTO> queue;
	
	
	static int count;
	public InstancePoller(String appService)
	{
		count++;
		this.appService = appService;
		sync = appService+"-queue";
		queue = new ConcurrentLinkedQueue<>();
		System.out.println("Starting Poller For "+appService+", count ("+count+")");
	}
	
	
	void add(WSTO to)
	{
		queue.add(to);
		
		synchronized (sync.intern())
		{
			sync.intern().notify();
		}
		
		
	}

	@Override
	public void run()
	{
		while(run)
		{
			t = System.currentTimeMillis();
			
			if(!WSSessions.get().isRunning(appService))
			{
				System.out.println("1 No running instance for "+appService+", closing the polling thread ");
				break;
			}
			
			if(queue == null || queue.size() == 0)
			{
				//wait(appUuid+" queue is empty !");
				wait(null); 
				continue;
			}
			
			
			 
			WSTO to = queue.peek();
			if(to == null)
			{
				wait(appService+" no items in queue !");
				continue;
			}
			
			SessionInstance session;
			try
			{
				session = WSSessions.get().getSessionForWorker(appService, to.instanceUuid);
			} 
			catch (NoRunningInstanceException e)
			{
				System.out.println("2 No running instance for "+appService+", closing the polling thread ");
				break;
			}
			
			if(session == null)
			{
				String apiPath = null;
				
				if(to.webSocketContext != null)
				{
					apiPath = to.webSocketContext.getApiPath();
				}
				else
				{
					apiPath = to.requestContext.getApiPath();
				}
				
				wait(appService+"  >>>>>  NO free ws session ! waiting .... "+apiPath);
				continue;
			}
			
			  
			to = queue.poll();
		
			
			RequestWorker worker = WorkerPool.get();
			if(worker == null)
			{
				worker = new RequestWorker();
				worker.start();
			}
		
			worker.set(to, session);
		}
		
		System.out.println("Poller Thread stoped for ("+appService+"), count("+count+")");
		run = false;
	}
	
	private void wait(String text)
	{
		try
		{
			long t0 = System.currentTimeMillis();
			
			synchronized (sync.intern())
			{
				//System.out.println(text);
				sync.intern().wait(50000);
				long t1 = System.currentTimeMillis();
				long t = t1-t0;
				
				if(text != null && t > 0)
				{
					System.out.println("Server waited : "+t+" : "+text);
				}
				
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
}
