package io.baltoro.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class BO extends BOBase
{

	
	private Map<String, String> metaData = new HashMap<>(100);
	private Map<String, Permission> permissionMap = new HashMap<>(100);
	private Set<String> roles = new HashSet<String>();
	
	public static BOMD[] FIELDS = {};
			
	@JsonIgnore 
	public abstract BOMD[] getMDDef();


	public String getValue(String name)
	{
		return metaData.get(name);
	}
	
	public void addValue(String name, String value)
	{
		metaData.put(name, value);
	}
	
	public Set<String> getRoles()
	{
		return roles;
	}
	
	public void addRole(String role)
	{
		roles.add(role);
	}
	
	public Map<String, String> getMDMap()
	{
		return metaData;
	}
	
	public Permission getPermission(String userUuid)
	{
		return permissionMap.get(userUuid);
	}
	
	public void addPermission(String userUuid, Permission permission)
	{
		permissionMap.put(userUuid, permission);
	}
	
}
