package io.baltoro.remote;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import io.baltoro.domain.App;
import io.baltoro.domain.BODefaults;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.Service;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.ReplicationContext;
import io.baltoro.to.ReplicationTO;
import io.baltoro.util.UUIDGenerator;

public class InstanceServletHelper
{

	private HttpServletRequest req;
	private HttpServletResponse res;
	
	
	public InstanceServletHelper(HttpServletRequest req, HttpServletResponse res)
	{
		this.req = req;
		this.res = res;
	}
	
	int getAllowedThreadPerInstance()
	{
		String instanceUuid = req.getParameter("instanceUuid");
		String appUuid = req.getParameter("appUuid");
		
		
		App app = null;
		int allowedCount = -1;
		try
		{
			app = (App) ServiceFactory.getInstance().get(appUuid);
			int currentCount = WSSessions.get().getSessionCount(app.getBaseUuid(), instanceUuid);
			int appCount = app.getAllowedInstanceThreadCount();//6
			int perInstCount = app.getAllowedPerInstanceThreadCount();//3
			
			allowedCount = perInstCount - currentCount;
		} 
		catch (ServiceException e)
		{
			e.printStackTrace();
		}
		
		return 3;//allowedCount;
	}
	
	String createInstance()
	{
		try
		{
			String appUuid = req.getParameter("appUuid");	
			String clusterPath = req.getParameter("clusterPath");	
			int liveThreads = 0;
			InstanceService instService = ServiceFactory.get(InstanceService.class);
			List<BaltoroInstance> insts = instService.find(appUuid);
			for (BaltoroInstance inst : insts)
			{
				if(!inst.getClusterPath().equals(clusterPath))
				{
					continue;
				}
				
				
				liveThreads = liveThreads+inst.getThreadCount();
				
			}
			
			Service service = ServiceFactory.getInstance();
			App app = service.get(appUuid, App.class);
			int tCount = app.getAllowedInstanceThreadCount();
			
		
			//if(tCount >= liveThreads)
			{
				BaltoroInstance instance = new BaltoroInstance();
				String uuid = UUIDGenerator.uuid("INST");
				instance.setAppUuid(appUuid);
				instance.setUuid(uuid);
				instance.setStartedOn(new Timestamp(System.currentTimeMillis()));
				instance.setThreadCount(app.getAllowedPerInstanceThreadCount());
				instance.setCreatedBy(BODefaults.BASE_USER);
				String localName =  Optional.ofNullable(InetAddress.getLocalHost().getHostName()).orElse(InetAddress.getLocalHost().getHostAddress());
				instance.setHostAddress(localName);
				instance.setRemoteAddress(req.getRemoteAddr());
				instance.setClusterPath(clusterPath);
				instService.insert(instance);
				
				return uuid;
			}
		
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
			
		
		return "NOT ALLOWED";
	}
	
	
	ReplicationTO getReplication()
	{
		try
		{
			String appUuid = req.getParameter("appUuid");	
			String instUuid = req.getParameter("instUuid");	
			String lcpUuid = req.getParameter("lcpUuid");	
			String _millis = req.getParameter("lcpMillis");
			String reset = req.getParameter("reset");
			
			ReplicationTO to = new ReplicationTO();
			to.appUuid = appUuid;
			to.instUuid = instUuid;
			to.lcpUuid = lcpUuid;
			to.reset = reset != null && reset.equals("true") ? true : false;
			
			long millis = -1;
			if(_millis != null)
			{
				millis = Long.parseLong(_millis);
			}
			to.lcpMillis = millis;
			
			InstanceService instService = ServiceFactory.get(InstanceService.class);
				
			List<ReplicationContext> list = instService.getReplication(to);
			to.list = list;
			
			return to;
		
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
			
		
		return null;
	}
	
	
}
