package io.baltoro.domain;

public class App extends BO
{

	private static final BOMD PUBLIC_KEY = new BOMD("public.key", ColTypeEnum.str_1); 
	private static final BOMD PRIVATE_DATA_UUID = new BOMD("private.data.uuid", ColTypeEnum.str_2);
	private static final BOMD ALLOWED_INST_THREADS = new BOMD("allowed.inst.thread.count", ColTypeEnum.int_1);
	private static final BOMD ALLOWED_PER_INST_THREADS = new BOMD("allowed.per.inst.thread.count", ColTypeEnum.int_1);
	
	@Override
	public BOMD[] getMDDef()
	{
		return new BOMD[]{PUBLIC_KEY, PRIVATE_DATA_UUID, ALLOWED_INST_THREADS};
	}

	
	
	
	public String getPublicKey() 
	{
		return getValue(PUBLIC_KEY.getName());
	}
	public void setPublicKey(String publicKey) 
	{
		addValue(PUBLIC_KEY.getName(), publicKey);
	}
	
	public String getPrivateDataUuid() 
	{
		return getValue(PRIVATE_DATA_UUID.getName());
	}
	public void setPrivateDataUuid(String privateDataUuid) 
	{
		addValue(PRIVATE_DATA_UUID.getName(), privateDataUuid);
	}
	
	
	public int getAllowedInstanceThreadCount() 
	{
		String val = getValue(ALLOWED_INST_THREADS.getName());
		if(val == null)
		{
			return 6;
		}
		else
		{
			return Integer.parseInt(val);
		}
		
	}
	public void setAllowedInstanceThreadCount(int count) 
	{
		addValue(ALLOWED_INST_THREADS.getName(), ""+count);
	}
	
	
	public int getAllowedPerInstanceThreadCount() 
	{
		String val = getValue(ALLOWED_PER_INST_THREADS.getName());
		if(val == null)
		{
			return 3;
		}
		else
		{
			return Integer.parseInt(val);
		}
		
	}
	public void setAllowedPerInstanceThreadCount(int count) 
	{
		addValue(ALLOWED_PER_INST_THREADS.getName(), ""+count);
	}
	
}
