/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.ResponseWorker;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WorkerPool;
import io.baltoro.to.WSTO;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.websocket.Session;

public class ResponsePoller
extends Thread {
    boolean run = true;

    @Override
    public void run() {
        while (this.run) {
            ConcurrentLinkedQueue<WSTO> queue;
            int count = WSSessions.get().checkSessions();
            if (count == 0) {
                System.out.println("No running sessions plz restart the instance ");
                System.exit(1);
            }
            if ((queue = WSSessions.get().getResponseQueue()) == null || queue.size() == 0) {
                this.wait("response queue is empty !");
                continue;
            }
            WSTO to = queue.peek();
            if (to == null) {
                this.wait(" No items in response queue !");
                continue;
            }
            Session session = WSSessions.get().getSessionForWork();
            if (session == null) {
                this.wait(" no free session ! try again in 50 secs ");
                continue;
            }
            to = queue.poll();
            ResponseWorker worker = WorkerPool.getResponseWorker();
            if (worker == null) {
                worker = new ResponseWorker();
                worker.start();
            }
            worker.set(to, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(String text) {
        try {
            String sync = "response-queue";
            String string = sync.intern();
            synchronized (string) {
                sync.intern().wait(50000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

