package io.baltoro.remote;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import io.baltoro.exception.NoRunningInstanceException;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.WSTO;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.StringUtil;


public class WSSessions
{

	private static WSSessions sessions;
	
	private Map<String, Set<SessionInstance>> sessionAppMap;
	private Map<String, InstancePoller> pollerMap;
	
	
	
	private WSSessions()
	{
		sessionAppMap = new HashMap<>(300);
		pollerMap = new HashMap<>(300);

	}
	
	public static WSSessions get()
	{
		if(sessions == null)
		{
			sessions = new WSSessions();
		}
		return sessions;
	}
	

	
	public void addSession(SessionInstance instance)
	{
		
		String appUuid = instance.getAppUuid();
		
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		if(set == null)
		{
			set = new HashSet<>();
			sessionAppMap.put(appUuid, set);
		}
		set.add(instance);
		
		
		InstancePoller poller = pollerMap.get(appUuid);
		if(poller == null)
		{
			String sync = appUuid+"-queue";
			synchronized (sync.intern())
			{
				poller = pollerMap.get(appUuid);
				if(poller == null)
				{
					poller = new InstancePoller(appUuid);
					pollerMap.put(appUuid, poller);
					poller.start();
				}
			}
		}
		

		
	}
	
	void send(WSTO to)
	{
		String appUuid = to.appUuid;
		String sync = appUuid+"-queue";
		
		
		InstancePoller poller = pollerMap.get(appUuid);
		if(poller == null || !poller.run)
		{
			synchronized (sync.intern())
			{
				poller = pollerMap.get(appUuid);
				if(poller == null || !poller.run)
				{
					poller = new InstancePoller(appUuid);
					pollerMap.put(appUuid, poller);
					poller.start();
				}
			}
		}
		
		
		poller.add(to);
		
		
	}
	
	
	boolean isRunning(String appUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		if(set == null || set.isEmpty())
		{
			return false;
		}
		return true;
	}
	

	int getSessionCount(String appUuid, String instanceUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		if(set == null)
		{
			return 0;
		}
		else
		{
			int count = 0;
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					count++;
				}
			}
			return count;
		}
	}
	
	SessionInstance getSession(String appUuid, String instanceUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		
		if(StringUtil.isNullOrEmpty(set))
		{
			return null;
		}
		
		
		if(StringUtil.isNotNullAndNotEmpty(instanceUuid))
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					return sessionInstance;
				}
			}
		}
		
		
		Optional<SessionInstance> instance = ObjectUtil.getRandom(set);
		
		return instance.orElse(set.iterator().next());
		
	}
	
	
	SessionInstance getSessionForWorker(String appUuid, String instanceUuid)
	throws NoRunningInstanceException
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		
		
		if(StringUtil.isNullOrEmpty(set))
		{
			throw new NoRunningInstanceException(appUuid);
		}
			
		
		String sync = appUuid+"-queue";
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					if(sessionInstance.working == false)
					{
						sessionInstance.working = true;
						return sessionInstance;
					}
					
				}
			}
		}
		
		
		
		return null;
		
	}
	

	
	public void removeSession(String appUuid, String instanceUuid, String wsSessionId)
	{
		//sessionInstranceMap.remove(appName+"-"+instanceUuid);
		String sync = appUuid+"-queue";
		
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		SessionInstance rmInstance = null;
		int instSessionCount = -1;
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					instSessionCount++;
					if(sessionInstance.getSession().getId().equals(wsSessionId))
					{
						rmInstance = sessionInstance;
						System.out.println("removed session instance "+sessionInstance);
					}
				}
			}
			
			
			if(rmInstance != null && set != null)
			{
				set.remove(rmInstance);
			}
		}
		
		
		
		if(instSessionCount == 0)
		{
			InstanceService service = ServiceFactory.get(InstanceService.class);
			
			try
			{
				service.update(instanceUuid, "DOWN1", 0, 0);
			} 
			catch (ServiceException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			InstancePoller poller = pollerMap.get(appUuid);
			if(poller != null)
			{
				poller.run = false;
				pollerMap.remove(appUuid);
				
				synchronized (sync.intern())
				{
					sync.intern().notify();
				}
			}
		}
	}
}
