package io.baltoro.remote;

import java.io.IOException;
import java.util.logging.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


@WebFilter("/probe3")
public class WSProbe3Filter implements Filter
{
	
	static Logger log = Logger.getLogger(WSProbe3Filter.class.getSimpleName());
	
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException
	{
		
		
		HttpServletRequest req = (HttpServletRequest) request;
		HttpSession httpSession = req.getSession(true);
		
		String examUuid = req.getParameter("examUuid");
		httpSession.setAttribute("examUuid", examUuid);
		
		chain.doFilter(request, response);
		
	}

	public void init(FilterConfig config) throws ServletException
	{
	}

	public void destroy()
	{
	}
}