/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.util.StringUtil;
import io.baltoro.to.WSTO;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.websocket.Session;

public class WSSessions {
    private static WSSessions sessions;
    private Set<Session> set = new HashSet<Session>();
    private ConcurrentLinkedQueue<ByteBuffer> requestQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<WSTO> responseQueue = new ConcurrentLinkedQueue();
    private Set<Session> busySessions = new HashSet<Session>();
    private ConcurrentLinkedQueue<Session> freeSessions = new ConcurrentLinkedQueue();

    private WSSessions() {
    }

    public static WSSessions get() {
        if (sessions == null) {
            sessions = new WSSessions();
        }
        return sessions;
    }

    ConcurrentLinkedQueue<ByteBuffer> getRequestQueue() {
        return this.requestQueue;
    }

    ConcurrentLinkedQueue<WSTO> getResponseQueue() {
        return this.responseQueue;
    }

    public void addSession(Session session) {
        this.freeSessions.add(session);
        this.set.add(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRequestQueue(ByteBuffer byteBuffer) {
        this.requestQueue.add(byteBuffer);
        String sync = "request-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToResponseQueue(WSTO to) {
        this.responseQueue.add(to);
        String sync = "response-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    int checkSessions() {
        if (StringUtil.isNullOrEmpty(this.set)) {
            return 0;
        }
        return this.set.size();
    }

    Session getSessionForWork() {
        if (StringUtil.isNullOrEmpty(this.set)) {
            this.freeSessions.clear();
            this.busySessions.clear();
            return null;
        }
        if (this.freeSessions.isEmpty()) {
            return null;
        }
        Session session = this.freeSessions.poll();
        this.busySessions.add(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSession(Session session) {
        this.freeSessions.add(session);
        this.busySessions.remove(session);
        String sync = "response-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    public void removeSession(Session session) {
        this.set.remove(session);
        this.busySessions.remove(session);
        this.freeSessions.remove(session);
        if (this.set.size() == 0) {
            System.out.println("No running sessions plz restart the instance ");
            System.exit(1);
        }
    }
}

