package io.baltoro.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.tomcat.websocket.WsSession;

import io.baltoro.domain.App;


public class WSSessionsWeb
{

	private static WSSessionsWeb sessions;
	
	private Map<String, WsSession> sessionMap;
	private Map<String, Set<String>> sessionAppMap;
		
	private WSSessionsWeb()
	{
		sessionMap = new HashMap<>(400);
		sessionAppMap = new HashMap<>(100);
	}
	
	public static WSSessionsWeb get()
	{
		if(sessions == null)
		{
			sessions = new WSSessionsWeb();
		}
		return sessions;
	}
	

	
	void addSession(App app, WsSession session)
	{
		
		sessionMap.put(app.getBaseUuid()+"-"+session.getId(), session);
		String appUuid = app.getBaseUuid();
		
		Set<String> set = sessionAppMap.get(appUuid);
		
		if(set == null)
		{
			set = new HashSet<>();
			sessionAppMap.put(appUuid, set);
		}
		set.add(session.getId());
		
	}
	


	
	void removeSession(String appUuid, String sessionId)
	{
		String wsSessionId = appUuid+"-"+sessionId;
		
		WsSession session = sessionMap.get(wsSessionId);
		if(session != null)
		{
			try
			{
				session.close();
			} 
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		
		sessionMap.remove(wsSessionId);
		
		Set<String> set = sessionAppMap.get(appUuid);
		
		if(set != null)
		{
			set.remove(sessionId);
		}
		
		
	}
	
	
	WsSession getSession(String appUuid, String sessionId)
	{
		return sessionMap.get(appUuid+"-"+sessionId);
	}
	
	WsSession getSession(String sessionUuid)
	{
		return sessionMap.get(sessionUuid);
	}
}
