package io.baltoro.remote;

import javax.websocket.Session;

public class SessionInstance
{
	private final String appUuid;
	private final String instanceUuid;
	//private final String appName;
	private final Session session;
	final long startedOn = System.currentTimeMillis();
	boolean working = false;
	
	public SessionInstance(String appUuid, String appName, String instanceUuid, Session session)
	{
		this.instanceUuid = instanceUuid;
		this.session = session;
		//this.appName = appName;
		this.appUuid = appUuid;
	}

	public String getInstanceUuid()
	{
		return instanceUuid;
	}

	public Session getSession()
	{
		return session;
	}
	
	
	
	public String getAppUuid()
	{
		return appUuid;
	}

	

	public long getStartedOn()
	{
		return startedOn;
	}

	@Override
	public String toString()
	{
		return appUuid+"-"+instanceUuid+"-"+session.getId();
	}
	
	public int hashCode()
	{

        return appUuid.hashCode() ^ session.getId().hashCode();
    }

    public boolean equals(Object obj)
    {
    	if(obj instanceof SessionInstance)
    	{
    		SessionInstance _sess = (SessionInstance) obj;
    		return appUuid.equals(_sess.appUuid) && session.getId().equals(_sess.getSession().getId());
    	}
    	else
    	{
    		return super.equals(obj);
    	}
    }
}
