/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.Replicator;
import io.baltoro.client.util.StringUtil;
import io.baltoro.client.util.UUIDGenerator;
import io.baltoro.db.Connection;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.Statement;
import io.baltoro.domain.BODefaults;
import io.baltoro.features.Replicate;
import io.baltoro.features.Store;
import io.baltoro.obj.Base;
import io.baltoro.to.ReplicationContext;
import io.baltoro.to.ReplicationTO;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.derby.impl.jdbc.EmbedConnection;

public class LocalDB {
    private ObjectMapper mapper = new ObjectMapper();
    private static LocalDB db;
    private String protocol = "jdbc:derby:";
    private String instUuid;
    private Connection con;
    private boolean clean;
    Map<String, String> typeClassMap = new HashMap<String, String>(100);
    Map<String, String> classTypeMap = new HashMap<String, String>(100);
    Map<String, MDFieldMap> classFieldMap = new HashMap<String, MDFieldMap>(1000);

    public static LocalDB instance(boolean clean) {
        if (db == null) {
            db = new LocalDB(Baltoro.instanceUuid, clean);
        }
        return db;
    }

    private LocalDB(String instUuid, boolean clean) {
        this.instUuid = instUuid;
        this.clean = clean;
        try {
            this.initLocalDB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLocalDB() throws Exception {
        try {
            EmbedConnection _con = (EmbedConnection)DriverManager.getConnection(this.protocol + this.instUuid + ";create=true");
            _con.setAutoCommit(true);
            this.con = new Connection((java.sql.Connection)_con);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (this.clean) {
                this.cleanUp();
            }
            this.con.createStatement().executeQuery("select uuid from base WHERE uuid='1'");
        }
        catch (SQLException e) {
            System.out.println("setting up local database.... " + e);
            Replicator.REPLICATION_ON = false;
            this.setupTables();
            Replicator.REPLICATION_ON = true;
        }
        try {
            this.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    void cleanUp() throws Exception {
        this.deleteTables();
    }

    void deleteTables() throws Exception {
        Statement st = this.con.createStatement();
        st = this.con.createStatement();
        st.execute("drop table base", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table version", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table metadata", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table link", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table permission", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table type", null);
        st.close();
        st = this.con.createStatement();
        st.execute("drop table lcp", null);
        st.close();
    }

    private void setupTables() throws Exception {
        Statement st = this.con.createStatement();
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE base (");
        sql.append("uuid varchar(42) NOT NULL,");
        sql.append("name varchar(32672) NOT NULL,");
        sql.append("state varchar(8) NOT NULL,");
        sql.append("type varchar(50) NOT NULL,");
        sql.append("container_uuid varchar(42) NOT NULL,");
        sql.append("latest_version_uuid varchar(42) NOT NULL,");
        sql.append("latest_version_number smallint NOT NULL,");
        sql.append("permission_type varchar(4) NOT NULL,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid))");
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("base", "name");
        this.createIndex("base", "created_on");
        this.createIndex("base", "container_uuid");
        this.createIndex("base", "type");
        this.createIndex("base", "name,container_uuid,type");
        System.out.println("Base Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE version (");
        sql.append("uuid varchar(42) NOT NULL,");
        sql.append("base_uuid varchar(42) NOT NULL,");
        sql.append("version_number smallint NOT NULL,");
        sql.append("name varchar(32672) NOT NULL,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid))");
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("version", "name");
        this.createIndex("version", "base_uuid");
        this.createIndex("version", "created_on");
        System.out.println("Version Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE metadata (");
        sql.append("base_uuid varchar(42) NOT NULL,");
        sql.append("version_uuid varchar(42) NOT NULL,");
        sql.append("name varchar(256) NOT NULL,");
        sql.append("value varchar(32672) NOT NULL,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (base_uuid,version_uuid,name))");
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("metadata", "name");
        this.createIndex("metadata", "base_uuid");
        this.createIndex("metadata", "version_uuid");
        System.out.println("Metadata Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE link (");
        sql.append("uuid varchar(42) NOT NULL,");
        sql.append("ctx_uuid varchar(42) NOT NULL,");
        sql.append("obj_type varchar(4) NOT NULL,");
        sql.append("sort smallint NOT NULL DEFAULT 5,");
        sql.append("seq smallint NOT NULL DEFAULT 5,");
        sql.append("count smallint NOT NULL DEFAULT 5,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid, ctx_uuid))");
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("link", "ctx_uuid");
        this.createIndex("link", "obj_type");
        this.createIndex("link", "count");
        this.createIndex("link", "ctx_uuid,obj_type,count");
        this.createIndex("link", "created_on");
        System.out.println("Link Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE permission (");
        sql.append("uuid varchar(42) NOT NULL,");
        sql.append("base_uuid varchar(42) NOT NULL,");
        sql.append("ctx_uuid varchar(42) NOT NULL,");
        sql.append("perm_read smallint NOT NULL DEFAULT 0,");
        sql.append("perm_edit smallint NOT NULL DEFAULT 0,");
        sql.append("perm_delete smallint NOT NULL DEFAULT 0,");
        sql.append("perm_link smallint NOT NULL DEFAULT 0,");
        sql.append("perm_grantt smallint NOT NULL DEFAULT 0,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid))");
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("permission", "base_uuid");
        this.createIndex("permission", "ctx_uuid");
        this.createIndex("permission", "created_on");
        System.out.println("Permission Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE type (");
        sql.append("class varchar(2000) NOT NULL,");
        sql.append("type varchar(5) NOT NULL,");
        sql.append("created_by varchar(42) NOT NULL, ");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (class))");
        System.out.println(sql.toString());
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        this.createIndex("type", "type");
        System.out.println("type Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE lcp (");
        sql.append("uuid smallint NOT NULL,");
        sql.append("lcp_uuid varchar(42),");
        sql.append("lcp_millis bigint,");
        sql.append("init_sync_on timestamp,");
        sql.append("last_sync_on timestamp,");
        sql.append("PRIMARY KEY (uuid))");
        System.out.println(sql.toString());
        st = this.con.createStatement();
        st.execute(sql.toString(), null);
        st.close();
        st = this.con.createStatement();
        st.execute("insert into lcp(uuid) values(1)", null);
        st.close();
        System.out.println("lcp Table Created");
    }

    private void createIndex(String tableName, String cols) throws Exception {
        Statement st = this.con.createStatement();
        String indexName = UUIDGenerator.randomString(6);
        String sql = "CREATE INDEX IDX_" + tableName + "_" + indexName.toUpperCase() + " on " + tableName + "(" + cols + ")";
        st.execute(sql, null);
        st.close();
    }

    public <T extends Base> T get(String baseUuid, Class<T> _class) {
        Base obj = null;
        try {
            obj = (Base)_class.newInstance();
            this.selectBase(baseUuid, obj);
            HashMap<String, Base> map = new HashMap<String, Base>();
            map.put(obj.getBaseUuid(), obj);
            this.addtMetadata(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (T)((Base)_class.cast(obj));
    }

    public List<Base> find(String[] baseUuids) {
        ArrayList<Base> objList = new ArrayList<Base>(200);
        try {
            String uuids = StringUtil.toInClause(baseUuids);
            String query = "select * from base where uuid in (" + uuids + ")";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String type = rs.getString("type");
                String objClass = this.getObjClass(type);
                Base obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(rs, obj);
                objList.add(obj);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objList;
    }

    public <T extends Base> T findOne(String name, Class<T> _class) {
        String type = this.getType(_class);
        List<T> objList = this.find(name, _class);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return (T)((Base)objList.get(0));
    }

    public <T extends Base> List<T> find(String name, Class<T> _class) {
        String type = this.getType(_class);
        ArrayList<Base> objList = new ArrayList<Base>(200);
        try {
            PreparedStatement st = this.con.prepareStatement("select * from base where name like ? and type=?");
            st.setString(1, name);
            st.setString(2, type);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                String objClass = this.getObjClass(type);
                Base obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(rs, obj);
                objList.add(obj);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objList;
    }

    public <T extends Base> List<T> find(Class<T> _class) {
        String type = this.getType(_class);
        ArrayList<Base> objList = new ArrayList<Base>(200);
        try {
            PreparedStatement st = this.con.prepareStatement("select * from base where type=?");
            st.setString(1, type);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                String objClass = this.getObjClass(type);
                Base obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(rs, obj);
                objList.add(obj);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objList;
    }

    public <T extends Base> T findFirstLinked(Class<T> _class, Base ... objs) {
        List<T> list = this.findLinked(false, _class, objs);
        if (list != null && !list.isEmpty()) {
            return (T)((Base)list.get(0));
        }
        return null;
    }

    public <T extends Base> List<T> findLinked(boolean debug, Class<T> _class, Base ... objs) {
        String type = this.getType(_class);
        try {
            String baseUuids = StringUtil.toInClause(objs);
            StringBuffer query = new StringBuffer();
            query.append("select ctx_uuid from link \n");
            query.append(" where ctx_uuid not in (" + baseUuids + ") \n");
            query.append(" and obj_type = ? \n");
            query.append(" and uuid in ( select distinct uuid from link \n");
            query.append(" where ctx_uuid in (" + baseUuids + ")\n");
            query.append(" and count = ? group by uuid having count(*) = ?)");
            PreparedStatement st = this.con.prepareStatement(query.toString());
            st.setString(1, type);
            st.setInt(2, objs.length + 1);
            st.setInt(3, objs.length);
            if (debug) {
                System.out.println(query);
                System.out.println("type = " + type + " , count = " + objs.length + 1);
            }
            ArrayList<String> uuidList = new ArrayList<String>(20);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("ctx_uuid");
                uuidList.add(uuid);
            }
            rs.close();
            st.close();
            if (!uuidList.isEmpty()) {
                List<Base> foundObjs = this.find(uuidList.toArray(new String[0]));
                return foundObjs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    private Base selectBase(String baseUuid, Base obj) throws Exception {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.con.prepareStatement("select * from base where uuid = ?");
            st.setString(1, baseUuid);
            rs = st.executeQuery();
            if (rs.next()) {
                this.buildBO(rs, obj);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addtMetadata(Map<String, Base> objMap) throws Exception {
        try {
            Statement st = this.con.createStatement();
            String inClause = StringUtil.toInClauseForMetadata(objMap.values());
            ResultSet rs = st.executeQuery("select * from metadata where version_uuid in (" + inClause + ")");
            while (rs.next()) {
                String baseUuid = rs.getString("base_uuid");
                String name = rs.getString("name");
                String value = rs.getString("value");
                Base obj = objMap.get(baseUuid);
                MDFieldMap fieldMap = this.classFieldMap.get(obj.getClass().getName());
                if (fieldMap == null) {
                    this.setupMetadataFields(obj);
                    fieldMap = this.classFieldMap.get(obj.getClass().getName());
                }
                Methods methods = (Methods)fieldMap.get(name);
                Method setMethod = methods.set;
                Class<?> fieldType = methods.field.getType();
                if (fieldType == Integer.TYPE) {
                    int v = Integer.parseInt(value);
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == Long.TYPE) {
                    long v = Long.parseLong(value);
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == Boolean.TYPE) {
                    boolean v = false;
                    if (value != null && value.equals("true")) {
                        v = true;
                    }
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == String.class || fieldType == StringBuffer.class) {
                    setMethod.invoke((Object)obj, value);
                    continue;
                }
                Object paramObj = this.mapper.readValue(value.getBytes(), fieldType);
                setMethod.invoke((Object)obj, paramObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildBO(ResultSet rs, Base obj) throws Exception {
        obj.setBaseUuid(rs.getString("uuid"));
        obj.setName(rs.getString("name"));
        obj.setState(rs.getString("state"));
        obj.setType(rs.getString("type"));
        obj.setContainerUuid(rs.getString("container_uuid"));
        obj.setLatestVersionUuid(rs.getString("latest_version_uuid"));
        obj.setVersionNumber(rs.getInt("latest_version_number"));
        obj.setPermissionType(rs.getString("permission_type"));
        obj.setCreatedBy(rs.getString("created_by"));
        obj.setCreatedOn(rs.getTimestamp("created_on"));
    }

    public void save(Base obj) {
        if (StringUtil.isNullOrEmpty(obj.getBaseUuid())) {
            String type = this.getType(obj.getClass());
            obj.setType(type);
            String uuid = UUIDGenerator.uuid(type);
            String versionUuid = UUIDGenerator.uuid(type);
            obj.setBaseUuid(uuid);
            obj.setVersionNumber(1);
            obj.setLatestVersionUuid(versionUuid);
            obj.setCreatedOn(new Timestamp(System.currentTimeMillis()));
            if (StringUtil.isNullOrEmpty(obj.getName())) {
                obj.setName(obj.getClass().getSimpleName() + "-" + obj.hashCode());
            }
            this.insertBase(obj);
            this.insertVersion(obj);
            this.insertMetadata(obj);
        } else {
            int vn = obj.getVersionNumber();
            obj.setVersionNumber(++vn);
            String versionUuid = UUIDGenerator.uuid(obj.getType());
            obj.setLatestVersionUuid(versionUuid);
            this.updateBase(obj);
            this.insertVersion(obj);
            this.insertMetadata(obj);
        }
    }

    private void insertBase(Base obj) {
        PreparedStatement st = null;
        try {
            st = this.con.prepareStatement("insert into base(uuid, name, state, type, container_uuid, latest_version_uuid, latest_version_number, permission_type, created_by, created_on) values(?,?,?,?,?,?,?,?,?,?)");
            st.setString(1, obj.getBaseUuid());
            st.setString(2, obj.getName());
            st.setString(3, obj.getState());
            st.setString(4, obj.getType());
            st.setString(5, obj.getContainerUuid());
            st.setString(6, obj.getLatestVersionUuid());
            st.setInt(7, obj.getVersionNumber());
            st.setString(8, obj.getPermissionType());
            st.setString(9, obj.getCreatedBy());
            st.setTimestamp(10, obj.getCreatedOn());
            Replicate repAnno = obj.getClass().getAnnotation(Replicate.class);
            if (repAnno != null) {
                String[] apps = repAnno.value();
                st.execute(apps);
            } else {
                st.execute(null);
            }
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBase(Base obj) {
        PreparedStatement st = null;
        try {
            st = this.con.prepareStatement("update base set name=?, latest_version_uuid =?, latest_version_number=? where uuid=? ");
            st.setString(1, obj.getName());
            st.setString(2, obj.getLatestVersionUuid());
            st.setInt(3, obj.getVersionNumber());
            st.setString(4, obj.getBaseUuid());
            Replicate repAnno = obj.getClass().getAnnotation(Replicate.class);
            if (repAnno != null) {
                String[] apps = repAnno.value();
                st.execute(apps);
            } else {
                st.execute(null);
            }
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertVersion(Base obj) {
        PreparedStatement st = null;
        try {
            st = this.con.prepareStatement("insert into version(uuid, base_uuid, version_number, name, created_by, created_on) values(?,?,?,?,?,?)");
            st.setString(1, obj.getLatestVersionUuid());
            st.setString(2, obj.getBaseUuid());
            st.setInt(3, obj.getVersionNumber());
            st.setString(4, obj.getName());
            st.setString(5, obj.getCreatedBy());
            st.setTimestamp(6, obj.getCreatedOn());
            Replicate repAnno = obj.getClass().getAnnotation(Replicate.class);
            if (repAnno != null) {
                String[] apps = repAnno.value();
                st.execute(apps);
            } else {
                st.execute(null);
            }
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupMetadataFields(Base obj) throws Exception {
        int i;
        ArrayList classes = new ArrayList();
        Class<?> clazz = obj.getClass();
        classes.add(obj.getClass());
        for (i = 0; i < 10 && (clazz = clazz.getSuperclass()) != Base.class; ++i) {
            classes.add(clazz);
        }
        for (i = classes.size() - 1; i >= 0; --i) {
            Field[] fields;
            Class _class = (Class)classes.get(i);
            for (Field field : fields = _class.getDeclaredFields()) {
                String getMethodName;
                Store storeAnno = field.getAnnotation(Store.class);
                if (storeAnno == null) continue;
                Class<?> fieldType = field.getType();
                System.out.println(" ---- > " + field.getName());
                String fieldName = field.getName();
                MDFieldMap mdFieldMap = this.classFieldMap.get(obj.getClass().getName());
                if (mdFieldMap == null) {
                    mdFieldMap = new MDFieldMap();
                    this.classFieldMap.put(obj.getClass().getName(), mdFieldMap);
                }
                Method getMethod = null;
                if (fieldType == Boolean.TYPE) {
                    getMethodName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    getMethod = _class.getMethod(getMethodName, new Class[0]);
                } else {
                    getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    getMethod = _class.getMethod(getMethodName, new Class[0]);
                }
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method setMethod = _class.getMethod(setMethodName, fieldType);
                Methods methods = new Methods();
                methods.get = getMethod;
                methods.set = setMethod;
                methods.field = field;
                mdFieldMap.put(field.getName(), methods);
            }
        }
    }

    private void insertMetadata(Base obj) {
        PreparedStatement st = null;
        try {
            HashMap<String, String> mdMap = new HashMap<String, String>();
            Map fieldMap = this.classFieldMap.get(obj.getClass().getName());
            if (fieldMap == null) {
                this.setupMetadataFields(obj);
                fieldMap = this.classFieldMap.get(obj.getClass().getName());
            }
            if (fieldMap == null) {
                return;
            }
            Set fieldNames = fieldMap.keySet();
            for (String fieldName : fieldNames) {
                System.out.println(" ---- > " + fieldName);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Methods methods = (Methods)fieldMap.get(fieldName);
                Method method = methods.get;
                Class<?> fieldType = methods.field.getType();
                Object mdObj = method.invoke((Object)obj, null);
                String value = null;
                if (mdObj == null) continue;
                value = fieldType.isPrimitive() ? mdObj.toString() : (fieldType == String.class || fieldType == StringBuffer.class || fieldType == StringBuilder.class ? mdObj.toString() : this.mapper.writeValueAsString(mdObj));
                mdMap.put(fieldName, value);
                System.out.println(mdObj);
            }
            st = this.con.prepareStatement("insert into metadata(base_uuid, version_uuid, name, value,created_by, created_on) values(?,?,?,?,?,?)");
            for (String mdName : mdMap.keySet()) {
                String value = (String)mdMap.get(mdName);
                st.setString(1, obj.getBaseUuid());
                st.setString(2, obj.getLatestVersionUuid());
                st.setString(3, mdName);
                st.setString(4, value);
                st.setString(5, obj.getCreatedBy());
                st.setTimestamp(6, obj.getCreatedOn());
                st.addbatch();
            }
            Replicate repAnno = obj.getClass().getAnnotation(Replicate.class);
            if (repAnno != null) {
                String[] apps = repAnno.value();
                st.executeBatch(apps);
            } else {
                st.executeBatch(null);
            }
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getType(Class _class) {
        String className = _class.getName();
        String type = this.classTypeMap.get(className);
        if (type != null) {
            return type;
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.con.prepareStatement("select * from type where class = ?");
            st.setString(1, className);
            rs = st.executeQuery();
            if (rs.next()) {
                type = rs.getString("type");
            }
            if (type != null) {
                this.classTypeMap.put(className, type);
                this.typeClassMap.put(type, className);
                return type;
            }
            st.close();
            String packageName = _class.getPackage().getName();
            StringBuffer str = new StringBuffer();
            str.append(_class.getSimpleName().substring(0, 2).toUpperCase());
            int index = packageName.indexOf(46);
            String pkg = packageName.substring(index + 1, index + 3).toUpperCase();
            str.append(pkg);
            type = str.toString();
            st = this.con.prepareStatement("insert into type(class,type,created_by, created_on) values (?,?,?,?)");
            st.setString(1, className);
            st.setString(2, type);
            st.setString(3, BODefaults.BASE_USER);
            st.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            st.execute(null);
            rs.close();
            st.close();
            this.classTypeMap.put(className, type);
            this.typeClassMap.put(type, className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    private String getObjClass(String type) {
        String objClass = this.typeClassMap.get(type);
        if (objClass != null) {
            return objClass;
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.con.prepareStatement("select * from type where type = ?");
            st.setString(1, type);
            rs = st.executeQuery();
            if (rs.next()) {
                objClass = rs.getString("class");
            }
            if (objClass != null) {
                this.classTypeMap.put(objClass, type);
                this.typeClassMap.put(type, objClass);
                return type;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objClass;
    }

    public String link(Base ... objs) {
        try {
            return this.insertLink(5, objs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String link(int sortOrder, Base ... objs) {
        try {
            return this.insertLink(sortOrder, objs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String insertLink(int sortOrder, Base ... objs) throws Exception {
        PreparedStatement st = this.con.prepareStatement("insert into link(uuid, ctx_uuid, obj_type,sort,seq,count, created_by, created_on)  values(?,?,?,?,?,?,?,?) ");
        String uuid = io.baltoro.util.UUIDGenerator.uuid("LINK");
        int seq = 0;
        for (Base base : objs) {
            st.setString(1, uuid);
            st.setString(2, base.getBaseUuid());
            st.setString(3, base.getType());
            st.setInt(4, sortOrder);
            st.setInt(5, ++seq);
            st.setInt(6, objs.length);
            st.setString(7, BODefaults.BASE_USER);
            st.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
            st.addbatch();
        }
        Replicate repAnno = objs[0].getClass().getAnnotation(Replicate.class);
        if (repAnno != null) {
            String[] apps = repAnno.value();
            st.executeBatch(apps);
        } else {
            st.executeBatch(null);
        }
        st.close();
        return uuid;
    }

    private void updateLCP(LCP lcp) throws Exception {
        PreparedStatement st = this.con.prepareStatement("update lcp set lcp_uuid=?, lcp_millis=?, init_sync_on=?, last_sync_on=? where uuid=1");
        st.setString(1, lcp.lcpUuid);
        st.setLong(2, lcp.lcpMillis);
        st.setTimestamp(3, lcp.initSyncOn);
        st.setTimestamp(4, lcp.lastSyncOn);
        st.executeNoReplication();
        st.close();
    }

    private LCP getLCP() throws Exception {
        PreparedStatement st = this.con.prepareStatement("select * from lcp where uuid=1");
        ResultSet rs = st.executeQuery();
        LCP lcp = new LCP();
        if (rs.next()) {
            String lcpUuid = rs.getString("lcp_uuid");
            long lcpMillis = rs.getLong("lcp_millis");
            Timestamp initSyncOn = rs.getTimestamp("init_sync_on");
            Timestamp lastSyncOn = rs.getTimestamp("last_sync_on");
            lcp.lcpUuid = lcpUuid;
            lcp.lcpMillis = lcpMillis;
            lcp.initSyncOn = initSyncOn;
            lcp.lastSyncOn = lastSyncOn;
        }
        rs.close();
        st.close();
        return lcp;
    }

    private void sync() throws Exception {
        LCP lcp = this.getLCP();
        boolean reset = lcp.initSyncOn == null;
        ReplicationTO to = Baltoro.cs.getReplication(Baltoro.appUuid, Baltoro.instanceUuid, lcp.lcpUuid, lcp.lcpMillis, reset);
        int syncCount = to.totalCount;
        List<ReplicationContext> list = to.list;
        if (list == null) {
            lcp.lcpUuid = "";
            lcp.lcpMillis = System.currentTimeMillis() - 2000L;
            lcp.lastSyncOn = new Timestamp(System.currentTimeMillis());
            lcp.initSyncOn = new Timestamp(System.currentTimeMillis());
            this.updateLCP(lcp);
            return;
        }
        System.out.print("[");
        ReplicationContext lastCtx = null;
        for (ReplicationContext ctx : list) {
            String[] sqls = ctx.getCmd().split(";");
            for (int i = 0; i < sqls.length; ++i) {
                Statement st = this.con.createStatement();
                st.executeNoReplication(sqls[i]);
                st.close();
            }
            lastCtx = ctx;
            System.out.print("-");
        }
        System.out.println("]");
        lcp.lcpUuid = lastCtx.getUuid();
        lcp.lcpMillis = lastCtx.getMillis();
        lcp.lastSyncOn = new Timestamp(System.currentTimeMillis());
        if (reset) {
            lcp.initSyncOn = new Timestamp(System.currentTimeMillis());
        }
        this.updateLCP(lcp);
    }

    private class Methods {
        Field field;
        Method get;
        Method set;

        private Methods() {
        }
    }

    private class MDFieldMap
    extends HashMap<String, Methods> {
        private MDFieldMap() {
        }
    }

    private class LCP {
        String lcpUuid;
        long lcpMillis;
        Timestamp initSyncOn;
        Timestamp lastSyncOn;

        private LCP() {
        }
    }
}

