package io.baltoro.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import org.apache.tomcat.websocket.WsSession;

import io.baltoro.domain.App;
import io.baltoro.domain.AppUserSession;


@ServerEndpoint(value = "/wsc1")
public class WSServerWeb
{
	
	
	private Timestamp startedOn;
	private App app;
	private String path;
	private SessionInstance sessionInstance;
	private String eToken;
	private HttpServletRequest req;
	private HttpServletResponse res;
	AppUserSession appUserSession;
	CQueue q = new CQueue(5000);
	
	
	static Logger log = Logger.getLogger(WSServerWeb.class.getSimpleName());
	

	@OnOpen
	public void onOpen(Session _session, EndpointConfig config)
	{

		
		startedOn = new Timestamp(System.currentTimeMillis());
		WsSession session = (WsSession) _session;
		
		/*
		HttpSession httpSession = HTTPSessions.getSession(session.getHttpSessionId());
		app = (App) httpSession.getAttribute("BLT_APP");
		path = (String) httpSession.getAttribute("BLT_METHOD_PATH");
		eToken = (String) httpSession.getAttribute("BLT_TOKEN");
		req = (HttpServletRequest)httpSession.getAttribute("WEB_REQUEST");
		res = (HttpServletResponse)httpSession.getAttribute("WEB_RESPONSE");
		*/
		
		/*
		sessionInstance = BLTRequest.getSessionInstance(app.getBaseUuid(), path, req, res);
		if(sessionInstance == null)
		{
			res.addHeader("BALTORO-ERROR", "App Node is not up !! "+path);
			res.getOutputStream().write( ("App Node ["+app.getName()+"] is not up !! "+path).getBytes());
			return;
		}
		
	
		
		appUserSession = BLTRequest.getAppUserSession(sessionInstance, req, res);
		
		CachePathMap pathCache = CachePathMap.get();
		BaltoroAppAPI api = pathCache.getBaltoroAppPath(app.getBaseUuid(), path);
		
		if(api == null)
		{
			res.sendError(HttpServletResponse.SC_NOT_FOUND, "resource not found");
			return;
		}
		*/
		
		byte[] bytes = new byte[]{1,1,1,1,};
		ByteBuffer buf = ByteBuffer.wrap(bytes);
		
		try
		{
			session.getBasicRemote().sendBinary(buf);
		} 
		catch (IOException e)
		{
			e.printStackTrace();
		}
		
		System.out.println("==== >  ,,, "+path);
		
		
	}

	@OnClose
	public void onClose(Session session)
	{
		
		System.out.println("Close Client  WS Connection ... "+session);
		//WSSessionsWeb.get().removeSession(session.getId());
		
	}

	
	@OnMessage
	public void onMessage(ByteBuffer buffer, Session _session)
	{
		WsSession session = (WsSession) _session;
		byte[] data = buffer.array();
		
		 
	}
	
}
