package io.baltoro.remote;

import java.nio.ByteBuffer;
import java.util.logging.Logger;

import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import org.apache.tomcat.websocket.WsSession;


@ServerEndpoint(value = "/probe2")
public class WSProbe2
{
	static Logger log = Logger.getLogger(WSProbe2.class.getSimpleName());
	//int counter = 0;
	//long lastPingReceived = 0;
	boolean run = false;
	int index;

	@OnOpen
	public void onOpen(Session _session, EndpointConfig config)
	{
		WsSession session = (WsSession) _session;
		System.out.println("Open Web  WS Connection ... "+session);
		run = true;
		//WSProbe1.probeWebSession.put(session.getId(), session);
	}

	@OnClose
	public void onClose(Session _session)
	{
		run = false;
		WsSession session = (WsSession) _session;
		System.out.println("Close Web  WS Connection ... "+session);
		//WSProbe1.probeWebSession.remove(session.getId());
	}

	

	@OnMessage
	public void onMessage(String text, Session _session)
	{
		WsSession session = (WsSession) _session;
		System.out.println("recived text from web : "+text);
		
		//counter = WSProbe1.counter>100 ? (WSProbe1.counter-100) : 0;
		
		
		while(run)
		{
			if(index == WSProbe1.index)
			{
				String key = "probe-data";
				synchronized (key.intern())
				{
					try
					{
						key.intern().wait(1000);
					} 
					catch (InterruptedException e)
					{
						e.printStackTrace();
						run = false;
					}
					continue;
				}
			}
			
			index = WSProbe1.index;
	
			
			try
			{
				byte[] bytes = WSProbe1.list.get(index);
				ByteBuffer buf = ByteBuffer.wrap(bytes);
				session.getBasicRemote().sendBinary(buf);
				session.getBasicRemote().flushBatch();
				
				Thread.sleep(5);
			} 
			catch (Exception e)
			{
				run = false;
				e.printStackTrace();
			}
		}
			
		
	}
	
}
