package io.baltoro.remote;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;

import io.baltoro.util.StreamUtil;


@ServerEndpoint(value = "/probe1")
public class WSProbe1
{
	
	static Logger log = Logger.getLogger(WSProbe1.class.getSimpleName());
	
	static int counter = 0;
	static int limit = 100;
	static int index;
	static boolean running = false;
	
	static List<byte[]> list = new ArrayList<>(limit*2);

	@OnOpen
	public void onOpen(Session _session, EndpointConfig config)
	{
		//WsSession session = (WsSession) _session;	
		running = true;
		counter = 0;	
		System.out.println("OPen Probe  WS Connection ... "+counter);
		
	}

	@OnClose
	public void onClose(Session session)
	{
		System.out.println("Close Probe  WS Connection ... "+counter);
		
	}

	
	@OnMessage
	public void onMessage(ByteBuffer buffer, Session _session)
	{
		//byte[] data = buffer.array();
		
		byte[] data = StreamUtil.decompress(buffer.array());
		
		index = counter % limit;
		list.add(index,data);
		counter++;
		
		
		int x = index % 10;
		if(x == 0)
		{
			System.out.println("reciveing frame from probe "+counter+" index : "+index);
		}
		  
		String key = "probe-data";
		synchronized (key.intern())
		{
			key.intern().notifyAll();
		}
		
		//System.out.println("data recived : "+data.length);
		
		/*
		for(String id : probeWebSession.keySet())
		{
			WsSession session = probeWebSession.get(id);
			ByteBuffer buf = ByteBuffer.wrap(data);
			try
			{
				//System.out.println("sending bytes .............. "+data.length);
				session.getBasicRemote().sendBinary(buf);
			} 
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		*/
		
		
		/*
		segmentQueue.add(data);
		System.out.println(" queue pointer : "+segmentQueue.getIndex());
		*/
		 
	}
	
}
