package io.baltoro.remote;

import java.io.IOException;
import java.util.logging.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import io.baltoro.domain.App;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.service.ServiceFactory;


@WebFilter("/wsc_remove")
public class WSFilterWeb implements Filter
{
	
	static Logger log = Logger.getLogger(WSFilterWeb.class.getSimpleName());
	
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException
	{
		
		
		HttpServletRequest req = (HttpServletRequest) request;
		HttpSession httpSession = req.getSession(true);
		
		String appName = req.getHeader("BLT_APP_NAME");
		String path = req.getHeader("BLT_METHOD_PATH");
		String eToken = req.getHeader("BLT_TOKEN");
		
		App app = (App) ServiceFactory.getInstance().getByName(appName, ObjectTypeEnum.APPW);
		
		if(app == null)
		{
			throw new ServletException("no app with name : "+appName);
		}
		
		String publicKey = app.getPublicKey();
		
		HttpServletResponse res = (HttpServletResponse) response;
		
		
		
		httpSession.setAttribute("BLT_APP", app);
		httpSession.setAttribute("BLT_METHOD_PATH", path);
		httpSession.setAttribute("BLT_TOKEN", eToken);
		
		httpSession.setAttribute("WEB_REQUEST", req);
		httpSession.setAttribute("WEB_RESPONSE", res);
		
		
		chain.doFilter(request, response);
		
	}

	public void init(FilterConfig config) throws ServletException
	{
	}

	public void destroy()
	{
	}
}