package io.baltoro.remote;

import java.io.IOException;
import java.util.logging.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import io.baltoro.domain.App;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.ServiceFactory;


@WebFilter("/ws")
public class WSFilter implements Filter
{
	
	static Logger log = Logger.getLogger(WSFilter.class.getSimpleName());
	
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException
	{
		
		
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		String appUuid = httpRequest.getHeader("BLT_APP_UUID");
		String instanceUuid = httpRequest.getHeader("BLT_INSTANCE_UUID");
		String eToken = httpRequest.getHeader("BLT_TOKEN");
		
		App app = null;
		try
		{
			app = ServiceFactory.getInstance().get(appUuid, App.class);
		} 
		catch (ServiceException e)
		{
			throw new ServletException(e);
		}
		
		String publicKey = app.getPublicKey();
		
		
		HttpSession httpSession = httpRequest.getSession(true);
		httpSession.setAttribute("BLT_APP", app);
		httpSession.setAttribute("BLT_INSTANCE_UUID", instanceUuid);
		httpSession.setAttribute("BLT_TOKEN", eToken);
		
		
		// secuirty check. enable later
		/*
		String encodedToken = CryptoUtil.decrypt(publicKey, eToken);
		String _token = new String(StringUtil.decode(encodedToken));
		
		String[] tokens = _token.split("|");
		Long timesytamp = Long.parseLong(tokens[0]);
		String _appUuid = tokens[1];
		
		if(appUuid.equals(_appUuid))
		{
			Long dif = System.currentTimeMillis() - timesytamp;
			if(dif > 30000)
			{
				throw new ServletException("token not valid !");
			}
		}
		else
		{
			throw new ServletException("token not valid !");
		}
		*/
		
		/*
        final WSPrincipal p = new WSPrincipal("client token",httpRequest.getSession(), appUuid, instanceUuid);
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(httpRequest) 
        {
            @Override
            public Principal getUserPrincipal() 
            {
                return p;
            }
        };
		*/
		
	
		chain.doFilter(request, response);
		
	}

	public void init(FilterConfig config) throws ServletException
	{
	}

	public void destroy()
	{
	}
}