package io.baltoro.remote;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.glassfish.jersey.servlet.ServletContainer;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.domain.App;
import io.baltoro.domain.AppUserSession;
import io.baltoro.domain.BODefaults;
import io.baltoro.domain.BaltoroAppAPI;
import io.baltoro.domain.BaltoroInstanceRequest;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.Service;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.ReplicationTO;
import io.baltoro.to.RequestContext;
import io.baltoro.to.UserSessionContext;
import io.baltoro.to.WSTO;
import io.baltoro.util.StringUtil;
import io.baltoro.util.UUIDGenerator;



public class RootServlet extends ServletContainer
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	static Log log = LogFactory.getLog(RootServlet.class);
	static Timer instMonitor;
	static ObjectMapper objectMapper = new ObjectMapper();
	

	@Override
	public void init(ServletConfig config) throws ServletException
	{
		log.info("/////////////////////////////");
		log.info("/////////[Starting Root Servlet]///////////");
		log.info("/////////////////////////////");
		
		if(instMonitor != null)
		{
			super.init(config);
			return;
		}
			
		synchronized ("RootServlet".intern())
		{
			if(instMonitor == null)
			{
				instMonitor = new Timer();
				instMonitor.schedule(new TimerTask()
				{
					
					@Override
					public void run()
					{
						log.info("############################### close dead inst ");
						InstanceService service = ServiceFactory.get(InstanceService.class);
						service.closeDeadInstances();
						
					}
				}, 15000, 15000);
			}
		}
		
		super.init(config);
	}
	
	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
			
	    String serverName = request.getServerName();
		String appName = serverName.substring(0,serverName.indexOf('.'));
		String path = request.getRequestURI().toLowerCase();
		
		if(StringUtil.isNullOrEmpty(appName))
		{
			System.out.println("appName is null");
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		}
		
		request.getSession(true);
		  
		System.out.println("**********************************");
		System.out.println(request.getMethod()+" ["+appName+"] -- "+path);
		System.out.println("**********************************");
	
		
		if(appName.equals("admin") && path.equals("/areyouthere"))
		{
			response.getWriter().write(""+System.currentTimeMillis());
			return;
		}
		
		if(appName.equals("admin") && path.equals("/getremaininginsancethreadscount"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			int allowedCount = helper.getAllowedThreadPerInstance();
			response.getWriter().write(""+allowedCount);
			return;
		}
		
		 
		
		if(appName.equals("admin") && path.equals("/createinstance"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			String uuid = helper.createInstance();
			response.getWriter().write(uuid);
			return;
		}
		
		if(appName.equals("admin") && path.equals("/getreplication"))
		{
			InstanceServletHelper helper = new InstanceServletHelper(request, response);
			ReplicationTO to = helper.getReplication();
			String json = objectMapper.writeValueAsString(to);

			response.setContentType("application/json");
			response.getWriter().write(json);
			return;
		}
		
		if(appName.equals("admin") && path.equals("/favicon.ico"))
		{
			super.service(request, response);
			return;
		}
		
		/*
		if(StringUtil.isNullOrEmpty(path) || path.equals("/"))
		{
			response.sendRedirect("/index.html");
			return;
		}
		*/
		
		
		  

		Service service = ServiceFactory.getInstance();
		App app = (App) service.getByName(appName, ObjectTypeEnum.APPW);
		if(app == null)
		{
			response.addHeader("BALTORO-ERROR", appName+ " does not exsists  "+path);
			response.getOutputStream().write( (appName+ " does not exsists  "+path).getBytes());
			return;
		}
		
		SessionInstance sessionInstance = BLTRequest.getSessionInstance(app.getBaseUuid(), path, request, response);
		if(sessionInstance == null)
		{
			response.addHeader("BALTORO-ERROR", "App Node is not up !! "+path);
			response.getOutputStream().write( ("App Node ["+appName+"] is not up !! "+path).getBytes());
			return;
		}
		
		
		AppUserSession appUserSession = BLTRequest.getAppUserSession(sessionInstance, request, response);
		
		CachePathMap pathCache = CachePathMap.get();
		BaltoroAppAPI api = pathCache.getBaltoroAppPath(app.getBaseUuid(), path);
		
		if(api == null)
		{
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "resource not found");
			return;
		}
		
		System.out.println("==== > "+api.getUuid()+" ,,, "+path);
		
		
		BaltoroInstanceRequest req = BaltoroInstanceRequest.get();
		req.setAPIUuid(api.getUuid());
		req.setAppUuid(sessionInstance.getAppUuid());
		req.setAddPath(path);
		req.setInstanceUuid(sessionInstance.getInstanceUuid());
		req.setSizeKB(-1);
		req.setBltSessionId(appUserSession.getUuid());

		
		long t0 = System.currentTimeMillis();
		req.setStartedOn(new Timestamp(t0));
		
		BaltoroReqProcessor.get().add(req);
		
		try
		{
			byte[] bytes = BLTRequest.processAppRequest(sessionInstance, appUserSession, api, appName, path, request, response);
			if(bytes != null)
			{
				response.getOutputStream().write(bytes);
				int size = bytes.length/1000 == 0 ? 1 : bytes.length/1000;
				req.setSizeKB(size);
			}
			else
			{
				System.out.println(path+" source not modified !!! ");
			}
		
			
		} 
		/*
		catch (ServiceException e)
		{
			e.printStackTrace();
			//log.info(" ------------------------- "+e.getMessage());
			req.setError(e.getMessage());
			
		}
		*/
		catch (Exception e)
		{
			e.printStackTrace();
			req.setError(e.getMessage());
			byte[] bytes = e.getMessage().getBytes();
			response.getOutputStream().write(bytes);
			int size = bytes.length/1000 == 0 ? 1 : bytes.length/1000;
			req.setSizeKB(size);
		}
		
	
		req.setMillisTaken((int)(System.currentTimeMillis() - t0));
		BaltoroReqProcessor.get().update(req);
		
		
	}
	
	
		
	
	
	
	
	
	
	
}
