/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.ClientWSSession;
import io.baltoro.client.util.StringUtil;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.websocket.Session;

public class WSSessions {
    private static WSSessions sessions;
    private Set<ClientWSSession> set = new HashSet<ClientWSSession>();
    private ConcurrentLinkedQueue<ByteBuffer> requestQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ByteBuffer> responseQueue = new ConcurrentLinkedQueue();

    private WSSessions() {
    }

    public static WSSessions get() {
        if (sessions == null) {
            sessions = new WSSessions();
        }
        return sessions;
    }

    ConcurrentLinkedQueue<ByteBuffer> getRequestQueue() {
        return this.requestQueue;
    }

    ConcurrentLinkedQueue<ByteBuffer> getResponseQueue() {
        return this.responseQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(ClientWSSession session) {
        String sync = "session-queue";
        String string = sync.intern();
        synchronized (string) {
            this.set.add(session);
            sync.intern().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRequestQueue(ByteBuffer byteBuffer) {
        this.requestQueue.add(byteBuffer);
        String sync = "request-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToResponseQueue(ByteBuffer byteBuffer) {
        this.responseQueue.add(byteBuffer);
        String sync = "response-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    int checkSessions() {
        if (StringUtil.isNullOrEmpty(this.set)) {
            return 0;
        }
        return this.set.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientWSSession getSession() {
        if (StringUtil.isNullOrEmpty(this.set)) {
            return null;
        }
        String sync = "session-queue";
        String string = sync.intern();
        synchronized (string) {
            for (ClientWSSession session : this.set) {
                if (session.isWorking()) continue;
                return session;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session) {
        ClientWSSession rm = null;
        String sync = "session-queue";
        String string = sync.intern();
        synchronized (string) {
            for (ClientWSSession cs : this.set) {
                if (!cs.getSession().getId().equals(session.getId())) continue;
                rm = cs;
            }
            if (rm != null) {
                this.set.remove(rm);
            }
            if (this.set.size() == 0) {
                System.out.println("No running sessions plz restart the instance ");
                System.exit(1);
            }
        }
    }
}

