/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.domain;

import java.sql.Timestamp;

public class Permission {
    private String baseUuid;
    private String sysBaseUuid;
    private boolean read;
    private boolean create;
    private boolean update;
    private boolean delete;
    private boolean relation;
    private boolean share;
    private boolean grant;
    private String createdBy;
    private Timestamp createOn;

    protected Permission() {
    }

    public Permission(String baseUuid, String sysBaseUuid, boolean read, boolean create, boolean update, boolean delete, boolean relation, boolean share, boolean grant) {
        this.baseUuid = baseUuid;
        this.sysBaseUuid = sysBaseUuid;
        this.read = read;
        this.create = create;
        this.update = update;
        this.delete = delete;
        this.relation = relation;
        this.share = share;
        this.grant = grant;
    }

    public static Permission initOwnerPermission(String baseUuid, String sysBaseUuid) {
        Permission p = new Permission();
        p.setBaseUuid(baseUuid);
        p.setSysBaseUuid(sysBaseUuid);
        p.read = true;
        p.create = true;
        p.delete = true;
        p.update = true;
        p.relation = true;
        p.share = true;
        p.grant = true;
        return p;
    }

    public static Permission initReadPermission(String baseUuid, String sysBaseUuid) {
        Permission p = new Permission();
        p.setBaseUuid(baseUuid);
        p.setSysBaseUuid(sysBaseUuid);
        p.read = true;
        return p;
    }

    public static Permission initCreatePermission(String baseUuid, String sysBaseUuid) {
        Permission p = new Permission();
        p.setBaseUuid(baseUuid);
        p.setSysBaseUuid(sysBaseUuid);
        p.read = true;
        p.create = true;
        return p;
    }

    public static Permission initUpdatePermission(String baseUuid, String sysBaseUuid) {
        Permission p = new Permission();
        p.setBaseUuid(baseUuid);
        p.setSysBaseUuid(sysBaseUuid);
        p.read = true;
        p.update = true;
        return p;
    }

    public static Permission initSharePermission(String baseUuid, String sysBaseUuid) {
        Permission p = new Permission();
        p.setBaseUuid(baseUuid);
        p.setSysBaseUuid(sysBaseUuid);
        p.read = true;
        p.share = true;
        return p;
    }

    public String getBaseUuid() {
        return this.baseUuid;
    }

    public void setBaseUuid(String baseUuid) {
        this.baseUuid = baseUuid;
    }

    public String getSysBaseUuid() {
        return this.sysBaseUuid;
    }

    public void setSysBaseUuid(String sysBaseUuid) {
        this.sysBaseUuid = sysBaseUuid;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isRelation() {
        return this.relation;
    }

    public void setRelation(boolean relation) {
        this.relation = relation;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Timestamp getCreateOn() {
        return this.createOn;
    }

    public void setCreateOn(Timestamp createOn) {
        this.createOn = createOn;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean share) {
        this.share = share;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public void setGrant(boolean grant) {
        this.grant = grant;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.baseUuid + ",");
        str.append(this.sysBaseUuid + ",");
        str.append(this.read + "," + this.create + "," + this.update + "," + this.delete + "," + this.relation + "," + this.share + "," + this.grant);
        return str.toString();
    }
}

