/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.client.WSSessions;
import io.baltoro.client.util.ObjectUtil;
import io.baltoro.to.ReplicationContext;
import io.baltoro.to.WSTO;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement42;

public class Replicator {
    static boolean REPLICATION_ON = false;
    static boolean INT_SYNC = false;

    public static String getSQL(PreparedStatement st) {
        EmbedPreparedStatement42 stmt = (EmbedPreparedStatement42)st;
        ParameterValueSet params = stmt.getParms();
        String thesql = stmt.getSQLText();
        StringBuffer postsql = new StringBuffer();
        String theparam = null;
        int i = 0;
        int current = 0;
        int length = thesql.length();
        while (current < length) {
            int quote = thesql.indexOf("'", current);
            int dblquote = thesql.indexOf("\"", current);
            int question = thesql.indexOf("?", current);
            if (quote == -1) {
                quote = length;
            }
            if (dblquote == -1) {
                dblquote = length;
            }
            if (question == -1) {
                question = length;
            }
            if (question < quote && question < dblquote) {
                try {
                    DataValueDescriptor ds = params.getParameter(i++);
                    String type = ds.getTypeName();
                    theparam = type.contains("INT") ? ds.getString() : "'" + ds.getString() + "'";
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                postsql.append(thesql.substring(current, question));
                if (theparam == null) {
                    postsql.append("null");
                } else {
                    postsql.append(theparam);
                }
                current = question + 1;
                continue;
            }
            if (quote < dblquote) {
                quote = thesql.indexOf("'", quote + 1);
                postsql.append(thesql.substring(current, quote + 1));
                current = quote + 1;
                continue;
            }
            if (dblquote < length) {
                dblquote = thesql.indexOf("\"", dblquote + 1);
                postsql.append(thesql.substring(current, dblquote + 1));
                current = dblquote + 1;
                continue;
            }
            postsql.append(thesql.substring(current, length));
            current = length;
        }
        return postsql.toString();
    }

    public static void push(PreparedStatement st, String[] apps) {
        if (!REPLICATION_ON) {
            return;
        }
        String sql = Replicator.getSQL(st);
        Replicator.push(sql, apps);
    }

    public static void push(String sql, String[] apps) {
        if (!REPLICATION_ON) {
            return;
        }
        WSTO to = new WSTO();
        to.instanceUuid = Baltoro.instanceUuid;
        to.appUuid = Baltoro.appUuid;
        to.appName = Baltoro.appName;
        ReplicationContext ctx = new ReplicationContext();
        ctx.setMillis(System.currentTimeMillis());
        ctx.setCmd(sql);
        if (apps != null) {
            ctx.setApps(apps);
        }
        to.replicationContext = ctx;
        byte[] bytes = null;
        try {
            bytes = ObjectUtil.toJason(to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteBuffer msg = ByteBuffer.wrap(bytes);
        WSSessions.get().addToResponseQueue(msg);
    }
}

