package io.baltoro.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;

import io.baltoro.exception.ServiceException;

public class StreamUtil
{
	

	public static byte[] toBytes(InputStream in) throws ServiceException
	{
		BufferedInputStream bis = new BufferedInputStream(in);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		BufferedOutputStream bos = new BufferedOutputStream(out);
		
		try
		{
			while(bis.available()>0) 
			{
				byte[] data = new byte[1024];
	            
	            int bytesRead=0;
	           
	            while( (bytesRead = bis.read(data)) != -1)
	            {
	            	bos.write(bytesRead);
	            }
	            
	        }
		} 
		catch (Exception e)
		{
			throw new ServiceException(e);
		}
		finally
		{
			try
			{
				bis.close();
				bos.close();
				out.close();
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
			
		}
		return out.toByteArray();
	}
	
	public static byte[] toBytes(Object obj) throws ServiceException
	{
		try
		{
			ByteArrayOutputStream out = new ByteArrayOutputStream();
		    ObjectOutputStream os = new ObjectOutputStream(out);
		    os.writeObject(obj);
		    return out.toByteArray();
		} 
		catch (Exception e)
		{
			throw new ServiceException(e);
		}
		
	    
	}
}
