package io.baltoro.remote.api;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ClientPool
{
	
	static Log log = LogFactory.getLog(ClientPool.class);
	
	private static ClientPool threadMap;
	private Map<String, ConcurrentLinkedQueue<String>> map;
	
	
	private ClientPool()
    {
		map = new HashMap<String, ConcurrentLinkedQueue<String>>(1000);
    }
	
	public static ClientPool getInstance()
	{
		if(threadMap == null)
		{
			synchronized ("1".intern())
            {
				if(threadMap == null)
				{
					threadMap = new  ClientPool();
				}
            }
		}
		
		return threadMap;
	}
	
	
	public Map<String, ConcurrentLinkedQueue<String>> getAllRequestQueues() 
	{
		return map;
	}

	public ConcurrentLinkedQueue<String> getRequestQueue(String mbSessionId)
	{
		ConcurrentLinkedQueue<String> pollingQueue = map.get(mbSessionId);
		if(pollingQueue != null)
		{
			return pollingQueue;
		}
		
			
		if(pollingQueue == null)
		{
			synchronized (mbSessionId.intern())
            {
            	pollingQueue = map.get(mbSessionId);
            	if(pollingQueue == null)
            	{
            		pollingQueue = new ConcurrentLinkedQueue<String>();
            		map.put(mbSessionId, pollingQueue);
            	}
                
            }
		}
		
		return pollingQueue;
	}
	
	public void clearRequestQueue(String mbSessionId)
	{
		map.remove(mbSessionId);
	}
}
