package io.baltoro.remote;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

import io.baltoro.exception.NoRunningInstanceException;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.ServiceFactory;
import io.baltoro.to.WSTO;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.StringUtil;


public class WSSessions
{

	private static WSSessions sessions;
	//private Map<String, Set<SessionInstance>> sessionAppNameMap;
	//private ConcurrentLinkedQueue<WSTO> workQueue;
	
	private Map<String, Set<SessionInstance>> sessionAppMap;
	private Map<String, ConcurrentLinkedQueue<WSTO>> appWSTOQueue;
	private Map<String, InstancePoller> pollerMap;
	
	//private ConcurrentLinkedQueue<SessionInstance> sessionInstrancQueue;
	
	//private ConcurrentLinkedQueue<SessionInstance> workQueue;
	
	
	//private Map<String, Map<String, ConcurrentLinkedQueue<SessionInstance>>> sessionMap = new HashMap<>(1000);
	
	private WSSessions()
	{
		//sessionInstranceMap = new HashMap<String, SessionInstance>(2000);
		sessionAppMap = new HashMap<>(300);
		appWSTOQueue = new HashMap<>(300);
		pollerMap = new HashMap<>(300);
		//sessionQueue = new ConcurrentLinkedQueue<>();
	}
	
	public static WSSessions get()
	{
		if(sessions == null)
		{
			sessions = new WSSessions();
		}
		return sessions;
	}
	
	ConcurrentLinkedQueue<WSTO> getQueue(String appName)
	{
		return appWSTOQueue.get(appName);
	}
	
	public void addSession(SessionInstance instance)
	{
		
		//sessionInstranceMap.put(instance.getAppName()+"-"+instance.getInstanceUuid(), instance);
		String appUuid = instance.getAppUuid();
		
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		if(set == null)
		{
			set = new HashSet<>();
			sessionAppMap.put(appUuid, set);
		}
		set.add(instance);
		
		
		InstancePoller poller = pollerMap.get(appUuid);
		if(poller == null)
		{
			String sync = appUuid+"-queue";
			synchronized (sync.intern())
			{
				poller = pollerMap.get(sessionAppMap);
				if(poller == null)
				{
					poller = new InstancePoller(appUuid);
					pollerMap.put(appUuid, poller);
					poller.start();
				}
			}
		}
		
		/*
		Map<String, ConcurrentLinkedQueue<SessionInstance>> appSessions = sessionMap.get(instance.getAppName());
		if(appSessions == null)
		{
			appSessions = new HashMap<String, ConcurrentLinkedQueue<SessionInstance>>(20);
			sessionMap.put(instance.getAppName(), appSessions);
		}
		ConcurrentLinkedQueue<SessionInstance> instanceQueue = appSessions.get(instance.getInstanceUuid());
		if(instanceQueue == null)
		{
			instanceQueue = new ConcurrentLinkedQueue<>();
			appSessions.put(instance.getInstanceUuid(), instanceQueue);
			
		}
		
		instanceQueue.add(instance);
		*/
		
	}
	
	void send(WSTO to)
	{
		String appUuid = to.appUuid;
		String sync = appUuid+"-queue";
		
		ConcurrentLinkedQueue<WSTO> queue = appWSTOQueue.get(appUuid);
		if(queue == null)
		{
			synchronized (sync.intern())
			{
				queue = appWSTOQueue.get(appUuid);
				if(queue == null)
				{
					queue = new ConcurrentLinkedQueue<>();
					appWSTOQueue.put(appUuid, queue);
				}
			}
		}
		
		InstancePoller poller = pollerMap.get(appUuid);
		if(poller == null)
		{
			synchronized (sync.intern())
			{
				poller = pollerMap.get(appUuid);
				if(poller == null)
				{
					poller = new InstancePoller(appUuid);
					pollerMap.put(appUuid, poller);
					poller.start();
				}
			}
		}
		
		
		
		queue.add(to);
		
		synchronized (sync.intern())
		{
			sync.intern().notify();
		}
		
	}
	
	
	boolean isRunning(String appUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		if(set == null || set.isEmpty())
		{
			return false;
		}
		return true;
	}
	

	int getSessionCount(String appUuid, String instanceUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		if(set == null)
		{
			return 0;
		}
		else
		{
			int count = 0;
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					count++;
				}
			}
			return count;
		}
	}
	
	SessionInstance getSession(String appUuid, String instanceUuid)
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		
		if(StringUtil.isNullOrEmpty(set))
		{
			return null;
		}
		
		
		if(StringUtil.isNotNullAndNotEmpty(instanceUuid))
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					return sessionInstance;
				}
			}
		}
		
		
		Optional<SessionInstance> instance = ObjectUtil.getRandom(set);
		
		return instance.orElse(set.iterator().next());
		
	}
	
	
	SessionInstance getSessionForWorker(String appUuid, String instanceUuid)
	throws NoRunningInstanceException
	{
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		
		
		if(StringUtil.isNullOrEmpty(set))
		{
			throw new NoRunningInstanceException(appUuid);
		}
		
		
		String sync = appUuid+"-queue";
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					if(sessionInstance.working == false)
					{
						sessionInstance.working = true;
						return sessionInstance;
					}
					
				}
			}
		}
		
		
		
		return null;
		
	}
	
	/*
	private SessionInstance getSession(String appName, String instanceUuid)
	{
		if(StringUtil.isNotNullAndNotEmpty(instanceUuid))
		{
			SessionInstance instance = sessionInstranceMap.get(appName+"-"+instanceUuid);
			if(instance != null)
			{
				return instance;
			}
		}
		
		
		Set<SessionInstance> set = sessionAppNameMap.get(appName);
		if(StringUtil.isNullOrEmpty(set))
		{
			return null;
		}
		
		Optional<SessionInstance> instance = ObjectUtil.getRandom(set);
		
		return instance.orElse(set.iterator().next());
		
	}
	*/
	
	public void removeSession(String appUuid, String instanceUuid, String wsSessionId)
	{
		//sessionInstranceMap.remove(appName+"-"+instanceUuid);
		String sync = appUuid+"-queue";
		
		Set<SessionInstance> set = sessionAppMap.get(appUuid);
		SessionInstance rmInstance = null;
		int instSessionCount = -1;
		synchronized (sync.intern())
		{
			for (SessionInstance sessionInstance : set)
			{
				if(sessionInstance.getInstanceUuid().equals(instanceUuid))
				{
					instSessionCount++;
					if(sessionInstance.getSession().getId().equals(wsSessionId))
					{
						rmInstance = sessionInstance;
						System.out.println("removed session instance "+sessionInstance);
					}
				}
			}
			
			
			if(rmInstance != null && set != null)
			{
				set.remove(rmInstance);
			}
		}
		
		
		
		if(instSessionCount == 0)
		{
			InstanceService service = ServiceFactory.get(InstanceService.class);
			
			try
			{
				service.update(instanceUuid, "DOWN1", 0, 0);
			} 
			catch (ServiceException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			InstancePoller poller = pollerMap.get(appUuid);
			if(pollerMap != null)
			{
				poller.run = false;
				pollerMap.remove(appUuid);
				
				synchronized (sync.intern())
				{
					sync.intern().notifyAll();
				}
			}
		}
	}
}
