package io.baltoro.remote;

import java.nio.ByteBuffer;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.to.WSTO;

public class RequestWorker extends  Thread
{
	private WSTO to;
	private SessionInstance session;
	static ObjectMapper objectMapper = new ObjectMapper();

	
	public RequestWorker(WSTO to, SessionInstance session)
	{
		this.to = to;
		this.session = session;
	}
	
	public void run()
	{
		
			
			try
			{
				
				session.working = true;
				byte[] data = objectMapper.writeValueAsBytes(to);
				ByteBuffer buffer = ByteBuffer.wrap(data);
				System.out.println(".................. sending "+to.requestContext.getApiPath());
				session.getSession().getBasicRemote().sendBinary(buffer);
				session.working = false;
				
				String sync = to.appUuid+"-queue";
				synchronized (sync.intern())
				{
					sync.intern().notify();
				}
				
				
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		
	}
}