/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Filter;
import io.baltoro.features.Param;
import io.baltoro.features.Path;
import io.baltoro.features.Timeout;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AnnotationProcessor {
    static Logger log = Logger.getLogger(AnnotationProcessor.class.getName());
    Map<String, WebMethod> pathMap = new HashMap<String, WebMethod>(100);
    static ObjectMapper mapper = new ObjectMapper();

    public Map<String, WebMethod> processAnnotation(String packageName) throws Exception {
        log.info("packageName = " + packageName);
        Set<Class<?>> classes = AnnotationProcessor.getClasses(packageName);
        for (Method[] methodArray : classes) {
            Annotation[] annoArray;
            log.info("class = " + methodArray);
            for (Annotation anno : annoArray = methodArray.getAnnotations()) {
                if (anno instanceof Filter) {
                    Filter filterAnno = (Filter)anno;
                    Method[] filter = methodArray;
                    WebMethodMap.getInstance().addFilter(filterAnno.value(), (Class<AbstractFilter>)filter);
                }
                if (anno instanceof Path) {
                    String cPath = ((Path)anno).value();
                    for (Method method : methodArray.getDeclaredMethods()) {
                        Timeout timeoutAnno;
                        WebMethod wm = this.processPathAnno(method, (Class<?>)methodArray, cPath);
                        if (wm == null || (timeoutAnno = method.getAnnotation(Timeout.class)) == null) continue;
                        wm.timeoutSec = timeoutAnno.value();
                    }
                }
                if (!(anno instanceof RolesAllowed)) continue;
                RolesAllowed roleAnno = (RolesAllowed)anno;
                String[] roles = roleAnno.value();
                for (int i = 0; i < roles.length; ++i) {
                    System.out.println("role allowed" + roles[i]);
                }
            }
        }
        for (String string : this.pathMap.keySet()) {
            System.out.println("PATH -> " + string + " --> " + this.pathMap.get(string));
        }
        return this.pathMap;
    }

    private WebMethod processPathAnno(Method method, Class<?> _class, String cPath) {
        WebMethod wm = null;
        if (method.isAnnotationPresent(Path.class)) {
            Path pathAnno = method.getAnnotation(Path.class);
            String fPath = null;
            String mPath = pathAnno.value();
            if (!mPath.startsWith("/")) {
                mPath = "/" + mPath;
            }
            fPath = cPath.equals("/") ? mPath : cPath + mPath;
            fPath = fPath.toLowerCase();
            wm = new WebMethod(fPath, _class, method);
            wm.authRequired = pathAnno.authRequired();
            wm.discoverable = pathAnno.discaoverable();
            this.pathMap.put(fPath, wm);
            StringBuilder mPropsJson = new StringBuilder();
            mPropsJson.append("{");
            Class<?> returnType = method.getReturnType();
            String rType = returnType == null ? "void" : returnType.getSimpleName();
            mPropsJson.append("\"output\":\"" + rType + "\",");
            if (returnType != null && !returnType.isPrimitive()) {
                Field[] fields = returnType.getFields();
                for (int i = 0; i < fields.length; ++i) {
                }
            }
            Parameter[] methodParms = method.getParameters();
            mPropsJson.append("\"input\":{");
            boolean inputFound = false;
            for (int i = 0; i < methodParms.length; ++i) {
                Parameter param = methodParms[i];
                Class<?> paramClass = param.getType();
                String annoName = null;
                Annotation[] annos = param.getAnnotations();
                for (int j = 0; j < annos.length; ++j) {
                    Annotation paramAnno = annos[j];
                    if (paramAnno.annotationType() != Param.class) continue;
                    Param annoPraram = (Param)paramAnno;
                    annoName = annoPraram.value();
                    inputFound = true;
                    mPropsJson.append("\"param\":{");
                    mPropsJson.append("\"parma-name\":\"" + annoName + "\",");
                    mPropsJson.append("\"data-type\":\"" + paramClass.getSimpleName() + "\"");
                    mPropsJson.append("},");
                }
            }
            if (inputFound) {
                mPropsJson.delete(mPropsJson.length() - 1, mPropsJson.length());
            }
            mPropsJson.append("}");
            mPropsJson.append('}');
            wm.propJson = mPropsJson.toString();
        }
        return wm;
    }

    static Set<Class<?>> getClasses(String packageName) throws Exception {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        HashSet masterClassSet = new HashSet();
        Set<Class<?>> set = reflections.getTypesAnnotatedWith(Path.class);
        masterClassSet.addAll(set);
        set = reflections.getTypesAnnotatedWith(Filter.class);
        masterClassSet.addAll(set);
        return masterClassSet;
    }
}

