package io.baltoro.util;

import java.util.Collection;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;

import io.baltoro.domain.App;
import io.baltoro.domain.BO;
import io.baltoro.domain.BODefaults;
import io.baltoro.domain.Container;
import io.baltoro.domain.Domain;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.domain.PrivateData;
import io.baltoro.domain.Role;
import io.baltoro.domain.User;
import io.baltoro.exception.ServiceException;
import io.baltoro.to.AppTO;
import io.baltoro.to.BaseTO;
import io.baltoro.to.ContainerTO;
import io.baltoro.to.DomainTO;
import io.baltoro.to.PrivateDataTO;
import io.baltoro.to.UserTO;

public class ObjectUtil
{

	static ObjectMapper mappper = new ObjectMapper();
	
	public static <T> T initBOByType(Class<T> type)
	throws ServiceException
	{
		try
		{
			return type.newInstance();
		} 
		catch (Exception e)
		{
			throw new ServiceException(e);
		}
		
	}
	
	public static BO initBOByType(String _type)
	throws ServiceException
	{
		ObjectTypeEnum type = ObjectTypeEnum.valueOf(_type);
		return initBOByType(type);
		
	}
	
	public static <T> BO initBOByType(ObjectTypeEnum type)
	throws ServiceException
	{
		
		BO bo = null;
		
		if(type == ObjectTypeEnum.CONT)
		{
			bo = new Container();
		}
		else if(type == ObjectTypeEnum.DOMN)
		{
			bo = new Domain();
		}
		else if(type == ObjectTypeEnum.ROLE)
		{
			bo = new Role();
		}
		else if(type == ObjectTypeEnum.APPW)
		{
			bo = new App();
			App app = (App) bo;
			app.setAllowedInstanceThreadCount(6);
		}
		else if(type == ObjectTypeEnum.PRVD)
		{
			bo = new PrivateData();
		}
		else if(type == ObjectTypeEnum.USER)
		{
			bo = new User();
			bo.setContainerUuid(BODefaults.BASE_CONTAINER);
		}
		else
		{
			throw new ServiceException(type+" not supported");
		}
		
		bo.setObjectType(type.toString());
		
		return bo;
	}
	
	public static <T extends BO> Class<?> fromType(String typeName) 
	{
		if(typeName.equals(ObjectTypeEnum.USER.toString()))
		{
			return User.class;
		}
		else if(typeName.equals(ObjectTypeEnum.CONT.toString()))
		{
			return Container.class;
		}
		else if(typeName.equals(ObjectTypeEnum.DOMN.toString()))
		{
			return Domain.class;
		}
		else if(typeName.equals(ObjectTypeEnum.APPW.toString()))
		{
			return App.class;
		}
		else if(typeName.equals(ObjectTypeEnum.PRVD.toString()))
		{
			return PrivateData.class;
		}
		
		return null;
	}
	
	public static <T extends BO> Class<?> fromUuid(String uuid) 
	{
		if(uuid.startsWith(ObjectTypeEnum.USER.toString()))
		{
			return User.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.CONT.toString()))
		{
			return Container.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.DOMN.toString()))
		{
			return Domain.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.PRVD.toString()))
		{
			return PrivateData.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.APPW.toString()))
		{
			return App.class;
		}
		
		
		return null;
	}
	
	public static <T extends BaseTO> Class<?> fromTypeTO(String type) 
	{
		if(type.equals(ObjectTypeEnum.USER.toString()))
		{
			return UserTO.class;
		}
		else if(type.equals(ObjectTypeEnum.CONT.toString()))
		{
			return ContainerTO.class;
		}
		else if(type.equals(ObjectTypeEnum.DOMN.toString()))
		{
			return DomainTO.class;
		}
		else if(type.equals(ObjectTypeEnum.APPW.toString()))
		{
			return AppTO.class;
		}
		else if(type.equals(ObjectTypeEnum.PRVD.toString()))
		{
			return PrivateData.class;
		}
		
		return null;
	}
	
	public static <T extends BaseTO> Class<?> fromUuidTO(String uuid) 
	{
		if(uuid.startsWith(ObjectTypeEnum.USER.toString()))
		{
			return UserTO.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.CONT.toString()))
		{
			return ContainerTO.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.DOMN.toString()))
		{
			return DomainTO.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.PRVD.toString()))
		{
			return PrivateDataTO.class;
		}
		else if(uuid.startsWith(ObjectTypeEnum.APPW.toString()))
		{
			return AppTO.class;
		}
	
		
		return null;
	}
	
	public static byte[] toJason(Object obj) throws Exception
	{
		byte[] bytes = mappper.writeValueAsBytes(obj);
		return bytes;
	}
	
	public static <E> Optional<E> getRandom (Collection<E> e) 
	{

	    return e.stream()
	            .skip((int) (e.size() * Math.random()))
	            .findFirst();
	}
		
}
