package io.baltoro.service;

import java.util.List;

import io.baltoro.domain.App;
import io.baltoro.domain.BO;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.domain.Container;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.domain.Permission;
import io.baltoro.domain.User;
import io.baltoro.exception.NotFoundException;
import io.baltoro.exception.ReadNotAllowedException;
import io.baltoro.exception.ServiceException;

public interface Service 
{
	
	public <T extends BO> T get(String baseUuid, Class<T> type) 
	throws ServiceException,NotFoundException,ReadNotAllowedException;
	
	public BO get(String baseUuid) throws ServiceException,NotFoundException,ReadNotAllowedException;
	
	public List<BO> getBOs(List<String> uuids) throws ServiceException;
	
	public List<BO> findBOByName(String name, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
	
	
	public BO getByName(String name, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException,NotFoundException;
	
	public BO getByName(String name, ObjectTypeEnum type) 
	throws ServiceException,NotFoundException;

	public <T extends BO> T createBO(String name, ObjectTypeEnum type) throws ServiceException;
	
	public Container createContainer(String name) throws ServiceException;
	
	
	public User createUser(String email, String password) throws ServiceException;
	
	public App createApp(String name) throws ServiceException;
	
	public void saveBO(BO bo) throws ServiceException;
	
	public List<BO> findByStateType(String state, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
			
	public int countByStateType(String state, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
			
	
	public void savePermissions(Permission permission)	
	throws ServiceException;
	
	public List<BO> findChildrenByType(String baseUuid, ObjectTypeEnum type)
	throws ServiceException;
	
	
}
