package io.baltoro.service;

import java.util.List;

import io.baltoro.domain.AppUserSession;
import io.baltoro.domain.BaltoroAppAPI;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.domain.BaltoroInstanceRequest;
import io.baltoro.exception.ServiceException;
import io.baltoro.to.PathTO;

public interface InstanceService
{
	public BaltoroInstance get(String uuid) throws ServiceException;
	
	public List<BaltoroInstance> find(String appUuid);
	
	public BaltoroInstance insert(BaltoroInstance obj) throws ServiceException;
	
	public BaltoroInstance update(String uuid, String state, int cpuPercent, int freeMemGB) throws ServiceException;
	
	public void updateInstanceStartedOn(String uuid, String clusterPath, String remoteAddress, int threads) throws ServiceException;
	
	public void closeDeadInstances();
	
	public List<BaltoroAppAPI> getAppAPI(String appUuid);
	
	public List<BaltoroAppAPI> registerAppAPI(String instanceUuid, String appUuid, List<PathTO> paths) throws ServiceException;
	
	public BaltoroInstanceRequest insert(BaltoroInstanceRequest obj) throws ServiceException;
	
	public void updateRequestTime(String uuid, int millis, int sizeKB, String error) throws ServiceException;
	
	
	public void createUserSession(AppUserSession obj);
	
	public void touchAppUserSession(String uuid) throws ServiceException;
	
	public void updateAppUserSessionAtt(String uuid, String userName, String json);
	
	public void closeAppUserSession(String uuid);
	
	public AppUserSession getUserSessionByUuid(String uuid);
	
	public List<AppUserSession> getUserSessionByAppUuid(String appUuid) throws ServiceException;
	
}
